<?php
/**
 * The template for displaying search results page
 *
 * @package WordPress
 * @subpackage human_connection
 * @since 1.0
 * @version 1.0
 */
?>

<?php get_header(); ?>

<div id="search-results-page" class="handwriting">
    
    <!--
    *
    *   Section: Welcome
    *
    -->
         
    <div id="top-section" class="row section top-section-wrap  color1">
        
        <div id="page-title-wrap" class="title-wrap">
            
            <div id="page-title">
                
                <h1>Searching...<br>Looking...<br>Hoping for Results<h1>
                    
            </div><!-- END #page-title -->
            
        </div><!-- END #page-title-wrap -->
        
        <div class="image-wrap">
            
            <div class="image-acent color4-grad-radial">
            </div>
            
            <div id="welcome-image">
                
                <div id="grad-box-1" class="color2">
                </div>
                
            </div>
            
        </div>
        
    </div><!-- END #top-section -->
    
    <!-- Gradient Edge -->       
    <div id="top-section-gradbottom" class="grad-bottom color1 color1-grad zindex10"></div>
    
    
    <!--
    *
    *   Section: Main
    *
    -->
    
    <!-- Gradient Edge -->    
    <div id="main-section-gradtop" class="grad-top color2 color2-grad zindex10">
    </div>
    
    <div id="main-section" class="section row color2 zindex10">
            
    	<div id="primary" class="content-area">
    	    
    		<div id="content" class="site-content" role="main">
    		    
    		    <div id="ms-container">
    		        
    		        <div id="masonry-loop">

                        <div class="grid-sizer" ></div>
                        <div class="gutter-sizer"></div>
                        
                        <?php 
                        // Loop criteria
                        $args= array(
                                        'post_type'      => 'any',
                                        'paged' => $paged,
                                        'posts_per_page' =>  10
                                    );
                
                        $query = new WP_Query($args); 
                        if ( have_posts() ) {
            			    // Start the Loop.
            			    while ( have_posts() ) :
            				    the_post();
            		    ?>
            		            <!-- Set the unique post ID and class -->
            				    <article id="post-<?php the_ID(); ?>"
            				                    <?php post_class('ms-item'); ?>
            				    >
            				        
                                	<?php
                                	// Page thumbnail and title
                                	the_post_thumbnail('medium-large');
                                	
                                	?>
                                	<header class="entry-header">
                                	    <h1 class="entry-title">
                                            <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" >
                                            <?php
                                        	the_title();
                                        	?>
                                            </a>
                                        </h1>
                                    </header><!-- .entry-header -->
                                	<div class="entry-content">
                                		<?php
                                    		// Post body content
                                			the_excerpt();
                                			?>
                                			
                                			By <?php the_author_posts_link(); ?> on <?php the_time('F jS, Y'); ?>  in <div class="cat-tag-wrap"> <?php the_category(', '); ?>. </div>
                                			
                                			<?php
                                			edit_post_link( __( 'Edit', 'human-connection' ), '<span class="edit-link">', '</span>' );
                                		?>
                                		
                                		
                                    </div><!-- .entry-content -->
        
                                </article><!-- #post-## -->
                                <?php
                    				// If comments are open or we have at least one comment, load up the comment template.
                    				if ( comments_open() || get_comments_number() ) {
                    					comments_template();
                    				}
                    				
            				endwhile;
                        ?>
                        
                        <script type="text/javascript">
            
                        jQuery(window).load(function() {
                          var container = document.querySelector('#ms-container');
                          var msnry = new Masonry( container, {
                            itemSelector: '.ms-item',
                            columnWidth: '.ms-item',                
                          });  
                          
                        });
                    
                      
                        </script>
                        
                        <?php
                        } else {
                        ?>
                                
                                <div class="search-results-none">
                                    
                        			<p><?php _e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'human_connection' ); ?>
                        			
                        			</p>
                        			
                        			<?php
                        				get_search_form();
                        			?>
                        			
                    			</div>
                    			
                    	<?php
                        } 
                        ?>
                    
    		        </div><!--/#masonry-loop-->
    		        
    		    </div><!-- #ms-container -->
    		    
                        <!-- Post Navigation -->
    		            <?php postnav_numberbar();?>

    		</div><!-- #content -->
    		
        	<!-- Page Navigation -->
            <?php pagenav_standard() ?>
    		
    	</div><!-- #primary -->
        
    	<div id="secondary" class="sidebar-area" >
        
            <ul id="sidebar">
                
                <?php if (is_active_sidebar('single-post-sidebar') ) {
                    
                        dynamic_sidebar( 'single-post-sidebar' );
                        
                } else { 
                    
                     get_sidebar();
                     
                }
                
                ?>
                
            </ul>
            
        </div><!-- #secondary -->

    </div><!-- /END #main-section -->
    
    <!-- Gradient edge -->
    <div id="main-section-gradbottom" class="grad-bottom color2 color2-grad zindex10"></div>
    
    <!--
    *
    *   Section: Pre-Footer
    *
    -->
    
    <div id="pre-footer-gradtop" class="grad-top color3 color3-grad zindex10">
    </div>
    
    <div id="pre-footer-section" class="section row color3 zindex10">
        
            <div id="footer-center-wrap" class="center-wrap">
                
                <div id="footer-form" class="contact-form handwriting"> 
                    <?php include('contact_form.php'); ?>
                </div><!-- END #footer-form -->
                
            </div><!-- END #footer-center-wrap -->
            
    </div><!-- END #pre-footer-section -->
    
    <div id="pre-footer-gradbottom" class="grad-bottom color3 color3-grad zindex10">
    </div>
    
    <script type="text/javascript">
    
        // This adds support for the masonary post layout
        function masonryInit() { 
        
        var elemSearch = document.querySelector('#masonry-loop');
        var msnry = new Masonry( elemSearch, {
            
                // options
                animationEngine: "best-available",
                itemSelector: '.ms-item',
                columnWidth: '.grid-sizer',
                gutter: '.gutter-sizer',
                percentPosition: true,
                stagger: 30,
            });
        };
        jQuery(window).on('load', function(){
            masonryInit()
        });
    
    </script>
    
</div><!-- END #standard-page -->

<?php get_footer(); ?>