<?php
/**
 * The Home template file
 *
 * @package WordPress
 * @subpackage Human Connection
 * @since 1.0
 * @version 1.0
 */
 ?>
           
<?php get_header(); ?>

<div id="home-page" class="handwriting">
    
    <!--
    *
    *   Section: Welcome
    *
    -->
    
    <div id="top-section" class="row section top-section-wrap  color1">
        
        <div id="top-content-wrap" class="content-area-wrap" >
        
            <div id="page-title-wrap" class="title-wrap">
                
                <div id="page-title">
                    
                    <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
                        
                       <?php  check_page_type('title');?>
                       
                    </a>
                    
                </div>
                
                <div id="page-desc" class="page-desc">
                    
                    <h3><?php  $meta_key = 'smashing_post_class';
                                echo get_post_meta( $post->ID, $meta_key, true ); ?>
                    </h3>
                    
                </div>
                
            </div><!-- END #page-title-wrap -->
            
            <div class="image-wrap">
                
                <div class="image-acent color4-grad-radial">
                </div>
                
                <div id="welcome-image">
                    
                    <div id="grad-box-1" class="color2">
                    </div>
                    
                </div>
                
            </div>
        
        </div>
        
    </div><!-- END #top-section -->
    
    <!-- Gradient edge -->
    <div id="top-section-gradbottom" class="grad-bottom color1 color1-grad zindex10">
    </div>
    
    <!--
    *
    *   Section: Main
    *
    -->
    
    <!-- Gradient edge -->
    <div id="main-section-gradtop" class="grad-top color2 color2-grad zindex10">
    </div>
            
    <div id="main-section" class="section section-content row color2 zindex10">
                
        <div id="primary" class="content-area">
            
            <div id="content" class="site-content" role="main">
            	    
        	    <div id="ms-container">
        	        
        	        <div id="masonry-loop" >
        	            
                        <div class="grid-sizer" ></div>
                        <div class="gutter-sizer"></div>
                        
                        <?php  
                        $args= array(
                                        'post_type'      => 'post',
                                        'paged' => $paged,
                                        'posts_per_page' =>  2
                                    );
                
                        $query = new WP_Query($args); 
            
            		    // Start the Loop.
            		    while ( have_posts() ) :
            		        
            			    the_post();
            	        ?>
            	        
            			    <article id="post-<?php the_ID(); ?>"
            			                    <?php post_class('ms-item mixed-format'); ?>
            			    >
            			        
                            	<?php the_post_thumbnail( 'medium_large' , array('class' => 'skip-lazy')); ?>
                            	
                            	<header class="entry-header">
                            	    
                            	    <h2 class="entry-title">
                            	        
                                        <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" >
                                            
                                        <?php the_title(); ?>
                                        
                                        </a>
                                        
                                    </h2>
                                    
                                </header><!-- .entry-header -->
                                
                            	<div class="entry-content">
                            	    
                            		<?php the_excerpt(); ?>
                            			
                        			By <?php the_author_posts_link(); ?> on <?php the_time('F jS, Y'); ?>  in <div class="cat-tag-wrap"> <?php the_category(', '); ?>. </div>
                        			
                        			<?php
                        			edit_post_link( __( 'Edit', 'human-connection' ), '<span class="edit-link">', '</span>' );
                            		?>
    
                                </div> <!-- .entry-content -->
            
                            </article><!-- #post-## -->
                            
                            <?php
                            
                				// If comments are open or we have at least one comment, load up the comment template.
                				if ( comments_open() || get_comments_number() ) {
                					comments_template();
                				}
                				
            			endwhile; // END The loop
            		        ?>
            	        
    	            </div> <!--/#masonry-loop-->
        	        
        	    </div> <!-- #ms-container -->
            	    
                <!-- Post navigation -->
	            <?php postnav_numberbar();?>
            
            </div> <!-- #content -->
                
            <!-- Page navigation -->
            <?php pagenav_standard() ?>
                    

        </div> <!-- END #primary -->

        <div id="secondary" class="sidebar" >
            
            <?php get_template_part( 'template_parts/sidebar_template'); ?>
            
        </div><!-- #secondary -->
    
    </div> <!-- /END #main-section -->

    <!-- Gradient edge -->    
    <div id="main-section-gradbottom" class="grad-bottom color2 color2-grad zindex10">
    </div>
    
    <!--
    *
    *   Section: Pre-Footer
    *
    -->

    <!-- Gradient edge -->    
    <div id="pre-footer-gradtop" class="grad-top color3 color3-grad zindex10">
    </div>
    
    <div id="pre-footer-section" class="section row color3 zindex10">
        
            <div id="footer-center-wrap" class="center-wrap">
                
                <div id="footer-form" class="contact-form handwriting">
                    
                    <?php include('contact_form.php'); ?>
                    
                </div><!-- END #footer-form -->
                
            </div><!-- END #footer-center-wrap -->
            
    </div><!-- END #pre-footer-section -->
    
    <!-- Gradient edge -->    
    <div id="pre-footer-gradbottom" class="grad-bottom color3 color3-grad zindex10">
    </div>
    
        <script type="text/javascript">
    
            // This adds support for the masonary post layout
                function masonryInit() { 
                
                var elemHome = document.querySelector('#masonry-loop');
                var msnry = new Masonry( elemHome, {
                    
                        // options
                        animationEngine: "best-available",
                        itemSelector: '.ms-item',
                        columnWidth: '.grid-sizer',
                        gutter: '.gutter-sizer',
                        percentPosition: true,
                        stagger: 30,
                    });
                };
                jQuery(window).on('load', function(){
                    masonryInit()
                });

            
        </script>

    
</div><!-- END #standard-page -->

<?php get_footer(); ?>