<?php
/**
 * The template for displaying comments

 * @package WordPress
 * @subpackage Human_Touch
 * @since 1.0
 * @version 1.0
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
- * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}
?>

<div id="comments" class="comments-area">

	<?php
	if ( have_comments() ) :
	?>
	
		<h2 class="comments-title">
		    
			<?php
			$comments_number = get_comments_number();
			
			if ( '1' === $comments_number ) {
			    
				/* translators: %s: post title */
				printf( _x( 'One Reply to &ldquo;%s&rdquo;', 'comments title', 'human-connection' ), get_the_title() );
				
			} else {
			    
				printf(
					/* translators: 1: number of comments, 2: post title */
					_nx(
						'%1$s Reply to &ldquo;%2$s&rdquo;',
						'%1$s Replies to &ldquo;%2$s&rdquo;',
						$comments_number,
						'comments title',
						'human-connection'
					),
					
					number_format_i18n( $comments_number ),
					get_the_title()
					
				);
				
			}
			?>
			
		</h2>

		<!--<ol class="comment-list">
			<?php /*
				wp_list_comments( array(
					'avatar_size' => 100,
					'style'       => 'ol',
					'short_ping'  => true,
					'reply_text'  => 'reply'. __( 'Reply', 'human-connection' ),
				) );
		*/	?>
		</ol> -->
		
    <?php

    function format_comment($comment, $args, $depth) {
    
           $GLOBALS['comment'] = $comment; ?>
           
    <li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
        <div id="comment-<?php comment_ID(); ?>" class="comment-body" >
        
            <div class="flexgroup-1">
                <div class="comment-author vcard">
                 <?php echo get_avatar($comment,$size='96',$default='' ); ?>
                
                 <?php printf(__('<cite class="fn">%s</cite>', 'human-connection'), get_comment_author_link()) ?>
                </div>
                <?php if ($comment->comment_approved == '0') : ?>
                 <em><?php _e('Your comment is awaiting moderation.', 'human-connection' ) ?></em>
                 <br />
                <?php endif; ?>
                
                <div class="comment-meta commentmetadata"><a href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ) ?>"><?php printf(__('<span class="date">%1$s</span> <span class="time">at %2$s</span>', 'human-connection'), get_comment_date(),  get_comment_time()) ?></a><?php edit_comment_link(__('(Edit)', 'human-connection'),'  ','') ?>
                </div>
                
            </div>
            
            <div class="flexgroup-2">
                
                <?php comment_text() ?>
                
            </div>
            
            <div class="reply">
                
                <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
                
            </div>
            
        </div>
        
    </li>
    
<?php } ?>

	<ol class="commentlist">
    <?php wp_list_comments('type=comment&callback=format_comment'); ?>
    </ol>
		
		
    <div class="page-numbers-wrap">
	<?php paginate_comments_links( array('prev_text' => '&laquo; Previous Comments', 'next_text' => 'Next &raquo;') );
	
    ?>
    
    </div>
    
    <?php
	endif; // Check for have_comments().

	// If comments are closed and there are comments we can notify
	if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) : ?>

		<p class="no-comments"><?php _e( 'Comments are closed.', 'human-connection' ); ?></p>
	<?php
	endif;

	comment_form();
	?>

</div><!-- #comments -->