<?php

/******************************
*
*      Check for Changes
*
*******************************/

//  Check the "color_palette_reset" toggle
$cp_reset_state = ($_COOKIE['cp_reset']);

if ( $cp_reset_state === '1' ) { 
    
    gicp_reset_palette();
	
	//  Change cookie value to 0
	$cookie_name = 'cp_reset';
	
    unset($_COOKIE[$cookie_name]);
    
    // empty value and expiration one hour before
    $res = setcookie($cookie_name, '', time() - 3600);
	
}


/******************************
*
*       Load Files
*
*******************************/

function my_enqueue_customizer_stylesheet() {

	wp_register_style( 'my-customizer-css', get_template_directory_uri() . '/css/customizer.css', NULL, NULL, 'all' );
	
	wp_enqueue_style( 'my-customizer-css' );

}

add_action( 'customize_controls_print_styles', 'my_enqueue_customizer_stylesheet', 10, 2 ); 



//   JS for live preview
function gi_customize_control_js() {
    wp_enqueue_script( 'gi_customizer_control', get_template_directory_uri() . '/js/customizer.js', array( 'customize-controls', 'jquery' ), null, true );
}

add_action( 'customize_controls_enqueue_scripts', 'gi_customize_control_js' );





/******************************
*
*     Style the Customizer
*
*******************************/

/**
 * Configuration sample for the Kirki Customizer.
 * The function's argument is an array of existing config values
 * The function returns the array with the addition of our own arguments
 * and then that result is used in the kirki_config filter
 *
 * @param $config the configuration array
 *
 * @return array
 */
function kirki_demo_configuration_sample_styling( $config ) {
	return wp_parse_args( array(
		'logo_image'   => 'http://sb2.glassinteractive.com/wp-content/themes/steel-theme/screenshot.png',
		'description'  => esc_attr__( 'The theme description.', 'steel-theme' ),
		'color_accent' => '#fcf8df',
		'color_back'   => '#5fa9bc',
	), $config );
}
add_filter( 'kirki_config', 'kirki_demo_configuration_sample_styling' );


function my_customizer_styles() { ?>

    <script>
        jQuery( document ).ready(function() {
            
            var colorOne = "<?php echo get_theme_mod( 'color_palette_c1', $themePaletteDefault[0] )?>";
                    
            var colorTwo = "<?php echo get_theme_mod( 'color_palette_c2', $themePaletteDefault[1] )?>";
            
            var colorThree = "<?php echo get_theme_mod( 'color_palette_c3', $themePaletteDefault[2] )?>";
            
            var colorFour = "<?php echo get_theme_mod( 'color_palette_c4', $themePaletteDefault[3] )?>";
            
            var colorFive = "<?php echo get_theme_mod( 'color_palette_c5', $themePaletteDefault[4] )?>";
            
            var colorSix = "<?php echo get_theme_mod( 'color_palette_c6', $themePaletteDefault[5] )?>";
            
            var colorSeven = "<?php echo get_theme_mod( 'color_palette_c7', $themePaletteDefault[6] )?>";
            
                        // This variable is global to allow use accross the document including customizer.js
            giThemeColorPalette = [ colorOne,
                                    colorTwo,
                                    colorThree,
                                    colorFour,
                                    colorFive,
                                    colorSix,
                                    colorSeven
                                  ];
    
        }); // END document ).ready   
        
    </script>';	

<?php
}
add_action( 'customize_controls_print_footer_scripts', 'my_customizer_styles', 999 );



/******************************
*
*     Color Palette Setup
*
*******************************/

global $wpdb;
$table_name = $wpdb->prefix . 'color_palettes';
//  Default color palette
$themePaletteDefault = array(
    
				$colorOne = $wpdb->get_var( "SELECT color1 FROM $table_name" ),
				$colorTwo = $wpdb->get_var( "SELECT color2 FROM $table_name" ),
				$colorThree = $wpdb->get_var( "SELECT color3 FROM $table_name" ),
				$colorFour = $wpdb->get_var( "SELECT color4 FROM $table_name" ),
				$colorFive = $wpdb->get_var( "SELECT color5 FROM $table_name" ),
				$colorSix = $wpdb->get_var( "SELECT color6 FROM $table_name" ),
				$colorSeven = $wpdb->get_var( "SELECT color7 FROM $table_name" ),

			);


//  Grab the custom palette colors if 
//  they exists. Otherwise use the default palette.
$colorOne = get_theme_mod( 'color_palette_c1', $themePaletteDefault[0] );
$colorTwo = get_theme_mod( 'color_palette_c2', $themePaletteDefault[1] );
$colorThree = get_theme_mod( 'color_palette_c3', $themePaletteDefault[2] );
$colorFour = get_theme_mod( 'color_palette_c4', $themePaletteDefault[3] );
$colorFive = get_theme_mod( 'color_palette_c5', $themePaletteDefault[4] );
$colorSix = get_theme_mod( 'color_palette_c6', $themePaletteDefault[5] );
$colorSeven = get_theme_mod( 'color_palette_c7', $themePaletteDefault[6] );

// Build the palette array
$themePalette = array(
    
				$colorOne,
				$colorTwo,
				$colorThree,
				$colorFour,
				$colorFive,
				$colorSix,
				$colorSeven,
				
			);





/******************************
*
*          Controls
*
*******************************/

// If the plugin is not active the controls will confuse the site. This ensures the controls will only load if the plugin is active.
include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
if ( is_plugin_active( 'kirki/kirki.php' ) ) {
    
    

    Kirki::add_config( 'my_theme_config', array(
    	'capability'    => 'edit_theme_options',
    	'option_type'   => 'theme_mod',
    	'transport'   => 'auto',
    ) );
    
    Kirki::add_panel( 'design', array(
        'priority'    => 10,
        'title'       => esc_attr__( 'Design', 'steel-theme' ),
        'description' => esc_attr__( 'Adjust the look and feel of youe website.', 'steel-theme' ),
    ) );


    /*
    ----------------------------
    
    SECTION:  Typography
    
    ----------------------------
    */
        
    $defaultFontFamily = 'Orbitron';
    $defaultFontFallback = 'sans-serif';
    $defaultVariant = 'regular';
    $defaultFontsize = '16px';
    $defaultLineHeight = 'normal';
    $defaultLetterSpacing = '0';
    $defaultTextTransform = 'none';
    
    $defaultFontFamilyTwo = 'Open Sans';
    $defaultFontFallbackTwo = 'sans-serif';
    
	Kirki::add_section( 'typography_section', array(
	    'title'          => esc_attr__( 'Typography', 'steel-theme' ),
	    'description'    => esc_attr__( 'Text settings.' ),
	    'panel'          => 'design',
	    'priority'       => 3,
	) );
    
        Kirki::add_field( 'my_theme_config', array(
        	'type'        => 'typography',
        	'settings'    => 'typography_set_main',
        	'label'       => esc_attr__( 'Typography Settings', 'steel-theme' ),
        	'section'     => 'typography_section',
        	'default'     => array(
        		'font-family'    => '"'.$defaultFontFamily.'", '.$defaultFontFallback,
        		'variant'        => $defaultVariant,
        		'font-size'      => $defaultFontsize,
        		'line-height'    => $defaultLineHeight,
        		'letter-spacing' => $defaultLetterSpacing,
        		'text-transform' => $defaultTextTransform,
        	),
        	'priority'    => 10,
        	'transport'   => 'auto',
        	'choices' => array(
                'fonts' => array(
                    'standard' => array(
            	   '"'.$defaultFontFamily.'", '.$defaultFontFallback,
            		'Georgia,Times,"Times New Roman",serif',
            		'Roboto, Oxygen-Sans, Ubuntu, Cantarell, "Helvetica Neue", sans-serif',
                	),
                    	'google'   => array( 'popularity', 200 ),
                ),
            ),
        	'output'      => array(
        		array(
        			'element' => '.handwriting',
        		    ),
        	    ),
            )
        );
        
         Kirki::add_field( 'my_theme_config', array(
        	'type'        => 'typography',
        	'settings'    => 'typography_set_alternate',
        	'label'       => esc_attr__( 'Typography Settings', 'steel-theme' ),
        	'section'     => 'typography_section',
        	'default'     => array(
        		'font-family'    => '"'.$defaultFontFamilyTwo.'", '.$defaultFontFallback,
        		'variant'        => $defaultVariant,
        		'font-size'      => $defaultFontsize,
        		'line-height'    => $defaultLineHeight,
        		'letter-spacing' => $defaultLetterSpacing,
        		'text-transform' => $defaultTextTransform,
        	),
        	'priority'    => 10,
        	'transport'   => 'auto',
        	'choices' => array(
                'fonts' => array(
                    'standard' => array(
            	   '"'.$defaultFontFamilyTwo.'", '.$defaultFontFallbackTwo,
            		'Georgia,Times,"Times New Roman",serif',
            		'Roboto, Oxygen-Sans, Ubuntu, Cantarell, "Helvetica Neue", sans-serif',
                	),
                    	'google'   => array( 'popularity', 200 ),
                ),
            ),
        	'output'      => array(
        		array(
        			'element' => '.typeprint, .single .postnav-outerwrap, .background-2, .page .entry-content p', 
        		    ),
        	    ),
            )
        );
        
    
    
    
    /*
    ----------------------------
    
    SECTION: Home and Front Page
    
    ----------------------------
    */
    
    Kirki::add_panel( 'home_page_settings', array(
        'title'          => esc_attr__( 'Home Page Settings', 'steel-theme' ),
        'description'    => esc_attr__( 'Chose, edit and fine-tune the home page', 'steel-theme' ),
        'panel'          => 'design',
        'priority'       => 10,
    ) );
    
    	Kirki::add_section( 'home_fp_selection', array(
    	    'title'          => esc_attr__( 'Select Your Home and Front Page', 'steel-theme' ),
    	    'description'    => esc_attr__( 'Choose if you would like the landing page to be the dynamic Human Connection front page or your own custom page.', 'steel-theme' ),
    	    'panel'          => 'home_page_settings',
    	    'priority'       => 10,
    	) );
    	
    		Kirki::add_field( 'my_theme_config', array(
    			'type'        => 'toggle',
    			'settings'    => 'front_page_selection',
    			'label'       => esc_attr__( 'Front Page Template', 'textdomain' ),
    			'section'     => 'home_fp_selection',
    			'default'     => '1',
    			'priority'    => 10,
    		) );
    
    

    	/* 
    	---------------------------
    	SUBSECTION: Front Page 
        Section 1 "Welcome Section"
        ---------------------------
        */
        
    	Kirki::add_section( 'home_fp_sec_1', array(
    	    'title'          => esc_attr__( 'Section 1: Welcome', 'steel-theme' ),
    	    'description'    => esc_attr__( 'This is the top section. It is designed to provide a warm greeting, basic information and gently move the user to specific content.', 'steel-theme' ),
    	    'panel'          => 'home_page_settings',
    	    'priority'       => 10,
    	) );
    
            //  Welcome section hide or show
            Kirki::add_field( 'my_theme_config', array(
            	'type'        => 'radio-buttonset',
            	'settings'    => 'fp_sec1__hide_toggle',
            	'label'       => esc_attr__( 'Activate or Deactivate this section on the Front Page', 'steel-theme' ),
            	'section'     => 'home_fp_sec_1',
            	'default'     => '',
            	'priority'    => 1,
            	'choices'     => array(
            		'' => esc_attr__( 'Active', 'steel-theme' ),
            		'none'  => esc_attr__( 'Disabled', 'steel-theme' ),
            	),
            	'output' => array(
                        array(
                            'element'  => '#front-page #top-section',
                            'property' => 'display',
                            'suffix'   => ' !important'
                        ),
                    ),
                ) 
            );
            
    		//  Welcome section first text
    		Kirki::add_field( 'my_theme_config', array(
    			'type'     => 'text',
    			'settings' => 'fp_sec1_text_a',
    			'label'    => __( 'Front Page Owner Name', 'steel-theme' ),
    			'section'  => 'home_fp_sec_1',
    			'description'  => esc_attr__( "This is where the name of the owner or the company name can go as part of the initial greeting. ", 'steel-theme' ),
    			'default'  => esc_attr__( "Your or a Company Name", 'steel-theme' ),
    			'priority' => 10,
    		    )
    		);
    		
    		//  Welcome section second text
    		Kirki::add_field( 'my_theme_config', array(
    			'type'     => 'text',
    			'settings' => 'fp_sec1_text_b',
    			'label'    => __( 'Inspirational Call to Action', 'steel-theme' ),
    			'section'  => 'home_fp_sec_1',
    			'description'  => esc_attr__( "This can be a brief mission statement or just an inspiration call to action. Anything to grab the mental and emotional attention of the viewer. ", 'steel-theme' ),
    			'default'  => esc_attr__( "Brief inspirational call to action", 'steel-theme' ),
    			'priority' => 10,
    			'input_attrs' => array(
    	            'maxlength' => '35',
    	            ),
    		    )
    		);
    		
    		//  Welcome section third text
    		Kirki::add_field( 'my_theme_config', array(
    			'type'     => 'text',
    			'settings' => 'fp_sec1_text_c',
    			'label'    => __( 'Direct Call to Action', 'steel-theme' ),
    			'section'  => 'home_fp_sec_1',
    			'description'  => esc_attr__( "Any statement that is short and direct can go here. The idea is to let th eview know it is time to move to the content. ", 'steel-theme' ),
    			'default'  => esc_attr__( "Are your ready?", 'steel-theme' ),
    			'priority' => 10,
    			'input_attrs' => array(
        	        'maxlength' => '17',
        	        ),
    		    )
    		);
    		
        	//  Welcome section image	
            Kirki::add_field( 'my_theme_config', array(
        	'type'        => 'image',
        	'settings'    => 'fp_welcome_image',
        	'label'       => esc_attr__( 'Welcome Image', 'steel-theme' ),
        	'description' => esc_attr__( 'By default, this will be the main image that is set in the "Branding and Images" section. You might want to make this different for the front page. That can be done below.', 'steel-theme' ),
        	'section'     => 'home_fp_sec_1',
        	'default'     => '',
        	'transport'   => 'refresh',
                )
            );
            
            //  Welcome section image accent gradient adjustment
            Kirki::add_field( 'my_theme_config', array(
        	'type'        => 'slider',
        	'settings'    => 'welcome_image_accent_position',
        	'label'       => __( 'Welcome Image Fine Adjustment', 'steel-theme' ),
        	'description' => esc_attr__( 'If the Welcome Image has a transparent background, or if you want to see more or less of the accent, this can be adjusted here. Simply move the slider to re-position the image accent to the desired spot.', 'steel-theme' ),
        	'section'     => 'home_fp_sec_1',
        	'default'     => '0',
        	'choices'     => array(
        		'min'  => '-100',
        		'max'  => '50',
        		'step' => '1',
        		
        	),
        	'output' => array(
                		array(
                			'element'  => '#top-section .image-acent',
                			'property' => 'transform',
                			'prefix' => 'translateX(35%) translateX(',
                			'suffix' => 'px)',
                		),
                	),
                ) 
            );
    

    	/* 
    	---------------------------
    	SUBSECTION: Front Page
        Section 2 "Main Section" ***
        ----------------------------
        */
        
    	Kirki::add_section( 'home_fp_sec_2', array(
    	    'title'          => esc_attr__( 'Section 2: Main Section', 'steel-theme' ),
    	    'description'    => esc_attr__( "This section is designed to be the first point of engagment. Generally this would be featured posts or details on advatages of your services or products, though the initial engagment could be anything that grabs the viewer's attention and guides them deeper intot the site. " ),
    	    'panel'          => 'home_page_settings',
    	    'priority'       => 10,
    	    ) 
    	);
    
            //  Main section hide or show
            Kirki::add_field( 'my_theme_config', array(
            	'type'        => 'radio-buttonset',
            	'settings'    => 'fp_sec2__hide_toggle',
            	'label'       => esc_attr__( 'Activate or Deactivate this section on the Front Page', 'steel-theme' ),
            	'section'     => 'home_fp_sec_2',
            	'default'     => '',
            	'priority'    => 1,
            	'choices'     => array(
            		'' => esc_attr__( 'Active', 'steel-theme' ),
            		'none'  => esc_attr__( 'Disabled', 'steel-theme' ),
            	),
            	'output' => array(
                        array(
                            'element'  => '#front-page #main-section',
                            'property' => 'display',
                            'suffix'   => ' !important'
                        ),
                    ),
                ) 
            );

    		//   Main section first text
    		Kirki::add_field( 'my_theme_config', array(
    			'type'     => 'text',
    			'settings' => 'fp_sec2_text_a',
    			'label'    => __( 'Section Title', 'steel-theme' ),
    			'section'  => 'home_fp_sec_2',
    			'default'  => esc_attr__( "Our Journey Inward", 'steel-theme' ),
    			'priority' => 10,
    		    ) 
    		);
    		
    		//  Main section second text
    		Kirki::add_field( 'my_theme_config', array(
    			'type'     => 'textarea',
    			'settings' => 'fp_sec2_text_b',
    			'label'    => __( 'Subtitle', 'steel-theme' ),
    			'section'  => 'home_fp_sec_2',
    			'default'  => esc_attr__( "Featured posts and tools to help you find insight, direction and a higher level of effectivness", 'steel-theme' ),
    			'priority' => 10,
    		    )
    		);
    		
    		//  Main section third text
    		Kirki::add_field( 'my_theme_config', array(
    			'type'     => 'text',
    			'settings' => 'fp_sec2_text_c',
    			'label'    => __( 'Direct Call to Action', 'steel-theme' ),
    			'section'  => 'home_fp_sec_2',
    			'description'  => esc_attr__( "Any statement that is short and direct can go here. The idea is to let th eview know it is time to move to the content. ", 'steel-theme' ),
    			'default'  => esc_attr__( "Find more insight and toold here", 'steel-theme' ),
    			'priority' => 10,
    		    ) 
    		);
    		
    		//  Main toggle tag filter
            Kirki::add_field( 'my_theme_config', array(
            	'type'        => 'switch',
            	'settings'    => 'fp_sec2_tag_toggle',
            	'label'       => esc_attr__( 'Tag Filter On/Off', 'textdomain' ),
            	'section'     => 'home_fp_sec_2',
            	'default'     => '0',
            	'priority'    => 10,
                ) 
            );
            
    		//  Main apply tag filter
            Kirki::add_field( 'my_theme_config', array(
                'type'        => 'select',
                'settings'    => 'fp_sec2_tag',
                'label'       => __( 'Select a Tag', 'steel-theme' ),
                'description' => __( 'This and optional setting to allow only posts with the chosen tags to show. Most commonly, "featured" would be used here. This can work with the tag filter or by itself.', 'steel-theme' ),
                'section'     => 'home_fp_sec_2',
                'default'     => 'option-1',
                'priority'    => 10,
                'choices'     => Kirki_Helper::get_terms( array(
                                'taxonomy' => 'post_tag',
                                'hide_empty' => false,
                        ) 
                    ),
                ) 
            );
            
    		//  Main toggle category filter
            Kirki::add_field( 'my_theme_config', array(
            	'type'        => 'switch',
            	'settings'    => 'fp_sec2_cat_toggle',
            	'label'       => esc_attr__( 'Category Filter On/Off', 'textdomain' ),
            	'section'     => 'home_fp_sec_2',
            	'default'     => '0',
            	'priority'    => 10,
                ) 
            );
            
    		//  Main apply category filter
            Kirki::add_field( 'my_theme_config', array(
                'type'        => 'select',
                'settings'    => 'fp_sec2_cat',
                'label'       => __( 'Select a Category', 'steel-theme' ),
                'description' => __( 'This allows the posts in this section to be filtered using a category. This can work with the tag filter or by itself.', 'steel-theme' ),
                'section'     => 'home_fp_sec_2',
                'default'     => '',
                'priority'    => 10,
                'choices'     => Kirki_Helper::get_terms( array(
                                'taxonomy' => 'category',
                                'hide_empty' => false,
                        ) 
                    ),
                ) 
            );        
    
    
        /*
    	---------------------------
        SUBSECTION: Front Page 
        Section 3 "Quote Section" 
        ----------------------------
        */
        
        Kirki::add_section( 'home_quote_text', array(
        'title'          => esc_attr__( 'Section 3: Quote Text', 'steel-theme' ),
        'description'    => esc_attr__( 'Edit and fine-tune the front page quote text', 'steel-theme' ),
        'panel'          => 'home_page_settings',
        'priority'       => 10,
            )
        );
        
            Kirki::add_field( 'my_theme_config', array(
            	'type'     => 'textarea',
            	'settings' => 'home_quote_text_a',
            	'label'    => __( 'Home Page Quote Text', 'human-connectio' ),
            	'section'  => 'home_quote_text',
            	'default'  => esc_attr__( "This is where an inspiring quote can be used to keep the viewer's attention and deepen their engagement. The ideal size for this is between 100 to 200 characters long, but almost any length will work.", 'human-connectio' ),
            	'priority' => 10,
                )
            );

            //  Quote section hide or show
            Kirki::add_field( 'my_theme_config', array(
            	'type'        => 'radio-buttonset',
            	'settings'    => 'fp_sec3__hide_toggle',
            	'label'       => esc_attr__( 'Activate or Deactivate this section on the Front Page', 'steel-theme' ),
            	'section'     => 'home_quote_text',
            	'default'     => '',
            	'priority'    => 1,
            	'choices'     => array(
            		'' => esc_attr__( 'Active', 'steel-theme' ),
            		'none'  => esc_attr__( 'Disabled', 'steel-theme' ),
            	),
            	'output' => array(
                        array(
                            'element'  => '#front-page #quote-section1',
                            'property' => 'display',
                            'suffix'   => ' !important'
                        ),
                    ),
                    
                ) 
            );
            
            //  Quote and author font size setting
            Kirki::add_field( 'my_theme_config', array(
            	'type'        => 'slider',
            	'settings'    => 'home_quote_font-size',
            	'label'       => __( 'Quote and Author Font Size', 'steel-theme' ),
            	'description' => esc_attr__( "Move the slider to raise or lower the font size.", 'steel-theme' ),
            	'section'     => 'home_quote_text',
            	'default'     => '18',
            	'choices'     => array(
            		'min'  => '12',
            		'max'  => '36',
            		'step' => '1',
            		
            	),
            	'output' => array(
            		array(
            			'element'  => '#quote-section1',
            			'property' => 'font-size',
            			'suffix' => 'px',
            		    ),
            	    ),
                )
            );
            
            //  Quote Top setting for fine adjustment
            Kirki::add_field( 'my_theme_config', array(
            	'type'        => 'slider',
            	'settings'    => 'home_quote_a_top',
            	'label'       => __( 'Quote Fine Adjustment', 'steel-theme' ),
            	'description' => esc_attr__( ': Move the slider to raise or lower the quote.', 'steel-theme' ),
            	'section'     => 'home_quote_text',
            	'default'     => '50',
            	'choices'     => array(
            		'min'  => '20',
            		'max'  => '80',
            		'step' => '1',
            		
            	),
            	'output' => array(
            		array(
            			'element'  => '#quote1a .page-quote',
            			'property' => 'top',
            			'prefix' => 'calc(',
            			'suffix' => '% - 2em )',
            		    ),
            	    ),
                ) 
            );
            
            //  Quote Author
            Kirki::add_field( 'my_theme_config', array(
            	'type'     => 'text',
            	'settings' => 'home_quote_text_b',
            	'label'    => __( 'Front Page Quote Author', 'steel-theme' ),
            	'section'  => 'home_quote_text',
            	'default'  => esc_attr__( "This is where the quote author can get some love.", 'human-connectio' ),
            	'priority' => 10,
                ) 
            );
            
            //  Quote Author
            Kirki::add_field( 'my_theme_config', array(
            	'type'     => 'text',
            	'settings' => 'home_quote_link',
            	'label'    => __( 'Link to the Author or Book (Optional)', 'steel-theme' ),
            	'section'  => 'home_quote_text',
            	'default'  => esc_attr__( "If supplied, the link will envelope the quote and author. ", 'steel-theme' ),
            	'priority' => 10,
                ) 
            );
            
            //  Author Top setting for fine adjustment
            Kirki::add_field( 'my_theme_config', array(
            	'type'        => 'slider',
            	'settings'    => 'home_quote_b_top',
            	'label'       => __( 'Author Fine Adjustment', 'steel-theme' ),
            	'description' => esc_attr__( "Move the slider to raise or lower the author's name.", 'steel-theme' ),
            	'section'     => 'home_quote_text',
            	'default'     => '50',
            	'choices'     => array(
            		'min'  => '20',
            		'max'  => '80',
            		'step' => '1',
            		
            	),
            	'output' => array(
            		array(
            			'element'  => '#quote1b .page-quote',
            			'property' => 'top',
            			'prefix' => 'calc(',
            			'suffix' => '% + 2em )',
            		    ),
            	    ),
                ) 
            );
            
            //  Author Left setting for fine adjustment
            Kirki::add_field( 'my_theme_config', array(
            	'type'        => 'slider',
            	'settings'    => 'home_quote_b_left',
            	'label'       => __( 'Author Fine Adjustment', 'steel-theme' ),
            	'description' => esc_attr__( "Move the slider to raise or lower the author's name.", 'steel-theme' ),
            	'section'     => 'home_quote_text',
            	'default'     => '50',
            	'choices'     => array(
            		'min'  => '20',
            		'max'  => '80',
            		'step' => '1',
            		
            	),
            	'output' => array(
            		array(
            			'element'  => '#quote1b .page-quote',
            			'property' => 'left',
            			'prefix' => 'calc(',
            			'suffix' => '% + 5em )',
            		    ),
            	    ),
                ) 
            );




    
    	/*
    	---------------------------
    	SUBSECTION: Front Page 
    	Section 4 "Secondary Section"
    	---------------------------
    	*/
    	
    	Kirki::add_section( 'home_fp_sec_4', array(
    	    'title'          => esc_attr__( 'Section 4: Secondary Section', 'steel-theme' ),
    	    'description'    => esc_attr__( 'This section can be used for more targeted engagment. Perhaps your a few general services or product groups. The minumum is one and the maximum shown is three.' ),
    	    'panel'          => 'home_page_settings',
    	    'priority'       => 10,
    	    ) 
    	);
    	
            //  Secondary section hide or show
            Kirki::add_field( 'my_theme_config', array(
            	'type'        => 'radio-buttonset',
            	'settings'    => 'fp_sec4__hide_toggle',
            	'label'       => esc_attr__( 'Activate or Deactivate this section on the Front Page', 'steel-theme' ),
            	'section'     => 'home_fp_sec_4',
            	'default'     => '',
            	'priority'    => 1,
            	'choices'     => array(
            		'' => esc_attr__( 'Active', 'steel-theme' ),
            		'none'  => esc_attr__( 'Disabled', 'steel-theme' ),
            	),
            	'output' => array(
                        array(
                            'element'  => '#front-page #secondary-section',
                            'property' => 'display',
                            'suffix'   => ' !important'
                        ),
                    ),
                ) 
            );
            
    		//  Main section first text
    		Kirki::add_field( 'my_theme_config', array(
    			'type'     => 'text',
    			'settings' => 'fp_sec4_text_a',
    			'label'    => __( 'Section Title', 'steel-theme' ),
    			'section'  => 'home_fp_sec_4',
    			'default'  => esc_attr__( "Our Journey Inward", 'steel-theme' ),
    			'priority' => 10,
    		    )
    		);
    		
    		//  Main section second text
    		Kirki::add_field( 'my_theme_config', array(
    			'type'     => 'textarea',
    			'settings' => 'fp_sec4_text_b',
    			'label'    => __( 'Subtitle', 'steel-theme' ),
    			'section'  => 'home_fp_sec_4',
    			'default'  => esc_attr__( "Featured posts and tools to help you find insight, direction and a higher level of effectivness", 'steel-theme' ),
    			'priority' => 10,
    		    )
    		);
    		
    		//  Main section third text
    		Kirki::add_field( 'my_theme_config', array(
    			'type'     => 'text',
    			'settings' => 'fp_sec4_text_c',
    			'label'    => __( 'Direct Call to Action', 'steel-theme' ),
    			'section'  => 'home_fp_sec_4',
    			'description'  => esc_attr__( "Any statement that is short and direct can go here. The idea is to let th eview know it is time to move to the content. ", 'steel-theme' ),
    			'default'  => esc_attr__( "Find more insight and toold here", 'steel-theme' ),
    			'priority' => 10,
    		    )
    		);
    		
    		//  Main toggle tag filter
            Kirki::add_field( 'my_theme_config', array(
            	'type'        => 'switch',
            	'settings'    => 'fp_sec4_tag_toggle',
            	'label'       => esc_attr__( 'Tag Filter On/Off', 'textdomain' ),
            	'section'     => 'home_fp_sec_4',
            	'default'     => '0',
            	'priority'    => 10,
                )
            );
            
    		//  Main apply tag filter
            Kirki::add_field( 'my_theme_config', array(
                'type'        => 'select',
                'settings'    => 'fp_sec4_tag',
                'label'       => __( 'Select a Tag', 'steel-theme' ),
                'description' => __( 'This and optional setting to allow only posts with the chosen tags to show. Most commonly, "featured" would be used here. This can work with the tag filter or by itself.', 'steel-theme' ),
                'section'     => 'home_fp_sec_4',
                'default'     => 'option-1',
                'priority'    => 10,
                'choices'     => Kirki_Helper::get_terms( array(
                                'taxonomy' => 'post_tag',
                                'hide_empty' => false,
                        )
                    ),
                ) 
            );
            
    		//  Main toggle category filter
            Kirki::add_field( 'my_theme_config', array(
            	'type'        => 'switch',
            	'settings'    => 'fp_sec4_cat_toggle',
            	'label'       => esc_attr__( 'Category Filter On/Off', 'textdomain' ),
            	'section'     => 'home_fp_sec_4',
            	'default'     => '0',
            	'priority'    => 10,
                ) 
            );
            
    		//  Main apply category filter
            Kirki::add_field( 'my_theme_config', array(
                'type'        => 'select',
                'settings'    => 'fp_sec4_cat',
                'label'       => __( 'Select a Category', 'steel-theme' ),
                'description' => __( 'This allows the posts in this section to be filtered using a category. This can work with the tag filter or by itself.', 'steel-theme' ),
                'section'     => 'home_fp_sec_4',
                'default'     => '',
                'priority'    => 10,
                'choices'     => Kirki_Helper::get_terms( array(
                                'taxonomy' => 'category',
                                'hide_empty' => false,
                        ) 
                    ),
                ) 
            );     

    
        /*
    	---------------------------
    	SUBSECTION: Front Page
    	Section 5 "Contact"
    	---------------------------
    	*/
    	
        //  Show or Hide the Contact Form and Fixed Contact Form
        Kirki::add_section( 'fp_contactform-section', array(
	    'title'          => esc_attr__( 'Section 5: Contact Form', 'steel-theme' ),
	    'description'    => esc_attr__( 'This is the last section of the page content that precedes the footer. This houses both the inline form and the form fixed to the bottom of the screen', 'steel-theme' ),
	    'panel'          => 'home_page_settings',
	    'priority'       => 10,
    	    ) 
    	);
    	
    	    //  Contact form toggle
            Kirki::add_field( 'my_theme_config', array(
            	'type'        => 'radio-buttonset',
            	'settings'    => 'fp_contactform_toggle',
            	'label'       => esc_attr__( 'Contact Form on the Front Page', 'steel-theme' ),
            	'section'     => 'fp_contactform-section',
            	'default'     => '',
            	'priority'    => 10,
            	'choices'     => array(
            		'' => esc_attr__( 'Active', 'steel-theme' ),
            		'none'  => esc_attr__( 'Disabled', 'steel-theme' ),
            	),
            	'output' => array(
                        array(
                            'element'  => '#pre-footer-section, #pre-footer-gradtop, #pre-footer-gradbottom',
                            'property' => 'display',
                            'suffix'   => ' !important'
                        ),
                    ),            	
                ) 
            );
            
            //  Fixed contact form toggle
            Kirki::add_field( 'my_theme_config', array(
            	'type'        => 'radio-buttonset',
            	'settings'    => 'fp_contactform_fixed_toggle',
            	'label'       => esc_attr__( 'Fixed Contact Form on the Front Page', 'steel-theme' ),
            	'section'     => 'fp_contactform-section',
            	'default'     => '',
            	'priority'    => 10,
            	'choices'     => array(
            		'' => esc_attr__( 'Active', 'steel-theme' ),
            		'none'  => esc_attr__( 'Disabled', 'steel-theme' ),
            	),
            	'output' => array(
                        array(
                            'element'  => '#fixed-form-wrap',
                            'property' => 'display',
                            'suffix'   => ' !important'
                        ),
                    ),
                    
                )
            );





    /*
    ----------------------------
    
    SECTION: Nav Controls
    
    ----------------------------
    */ 
    
    Kirki::add_section( 'nav_settings', array(
        'title'          => esc_attr__( 'Navigation Settings', 'steel-theme' ),
        'description'    => esc_attr__( 'Navigation Settings description.', 'steel-theme' ),
        'panel'          => 'design',
        'priority'       => 10,
        ) 
    );
    
        //  Show or Hide the Admin Bar
        Kirki::add_field( 'my_theme_config', array(
        	'type'        => 'switch',
        	'settings'    => 'top-bar-toggle',
        	'label'       => esc_attr__( 'Hide Admin on the frontend of your site', 'steel-theme' ),
        	'description'    => esc_attr__( 'While you can not see the Admin Bar here in teh Customizer, it is shown, be default on the frontend of your website. This can be easily removed by using this switch. DO NOT FORGET TO CLICK "PUBLISH" TO VIEW THIS CHANGE ON THE FRONTEND', 'steel-theme' ),
        	'section'     => 'nav_settings',
        	'default'     => 'true',
        	'priority'    => 10,
        	'transport'   => 'refresh',
        	'choices'     => array(
        		'on'  => esc_attr__( 'Click here to HIDE the Admin Bar on the front end.', 'steel-theme' ),
        		'off' => esc_attr__( 'Click here to SHOW the Admin Bar on the front end.', 'steel-theme' ),
        	    ),	
            )
        );
        
        
        //  Nav menu margin RIGHT 
        Kirki::add_field( 'my_theme_config', array(
        	'type'        => 'slider',
        	'settings'    => 'theme_nav_container_margintop',
        	'label'       => __( 'Menu Top Margin', 'steel-theme' ),
        	'description' => esc_attr__( ': Move the slider to raise or lower the logo.', 'steel-theme' ),
        	'section'     => 'nav_settings',
        	'default'     => '7',
        	'choices'     => array(
        		'min'  => '0',
        		'max'  => '50',
        		'step' => '1',
        		
        	),
        	'output' => array(
        		array(
        			'element'  => '.blog-masthead.main-menu .container',
        			'property' => 'margin-top',
        			'suffix' => 'px',
        		    ),
        	    ),
            )
        );
        
        //  Nav menu margin LEFT
        Kirki::add_field( 'my_theme_config', array(
        	'type'        => 'slider',
        	'settings'    => 'theme_nav_container_marginleft',
        	'label'       => __( 'Menu Left Margin', 'steel-theme' ),
        	'description' => esc_attr__( ': Move the slider to add space on the left of the menu.', 'steel-theme' ),
        	'section'     => 'nav_settings',
        	'default'     => '7',
        	'choices'   => array(
        		'min'  => '0',
        		'max'  => '10',
        		'step' => '1',
        		
        	),
        	'output' => array(
        		array(
        			'element'  => '.blog-masthead.main-menu .container',
        			'property' => 'margin-left',
        			'suffix' => 'px',
        		    ),
        	    ),
            )
        );
        
        // Inner menu pad
        // Used to dynamically set the nav padding suffix.
        $navpad_suf_set = get_theme_mod( 'nav_pad_suffix', 'px' );

        //  Nav pad TOP and BOTTOM
        Kirki::add_field( 'my_theme_config', array(
        	'type'        => 'slider',
        	'settings'    => 'nav_pad-topbottom',
        	'label'       => __( 'Inner Menu Padding: Top and Bottom', 'steel-theme' ),
        	'description' => esc_attr__( 'This is a color control - without alpha channel.', 'steel-theme' ),
        	'section'     => 'nav_settings',
        	'default'     => '1',
        	'choices'     => array(
        		'min'  => '0.5',
        		'max'  => '100',
        		'step' => '0.5',
        	),
        	'output' => array(
        		array(
        			'element'  => '.blog-masthead .gi-main-menu',
        			'property' => 'padding-top',
        			'suffix' => $navpad_suf_set,
        		),
        		array(
        			'element'  => '.blog-masthead .gi-main-menu',
        			'property' => 'padding-bottom',
        			'suffix' => $navpad_suf_set,
        		    ),
        	    ),
            )
        );
        
        //  Nav pad SUFFIX
        Kirki::add_field( 'my_theme_config', array(
        	'type'        => 'select',
        	'settings'    => 'nav_pad_suffix',
        	'label'       => __( 'Units', 'steel-theme' ),
        	'description' => esc_attr__( 'This is a color control - without alpha channel.', 'steel-theme' ),
        	'section'     => 'nav_settings',
        	'default'     => 'px',
        	'priority'    => 10,
        	'multiple'    => 1,
        	'choices'     => array(
        		'px' => esc_attr__( 'Pixels', 'steel-theme' ),
        		'%' => esc_attr__( 'Percent', 'steel-theme' ),
        		'em' => esc_attr__( 'EM (Element Relative)', 'steel-theme' ),
        	    ),
            )
        );
        
        //  Nav pad LEFT
        Kirki::add_field( 'my_theme_config', array(
        	'type'        => 'slider',
        	'settings'    => 'nav_pad-leftright',
        	'label'       => __( 'Inner Menu Padding: Left and Right Sides', 'steel-theme' ),
        	'description' => esc_attr__( 'This is a color control - without alpha channel.', 'steel-theme' ),
        	'section'     => 'nav_settings',
        	'default'     => '0',
        	'choices'     => array(
        		'min'  => '0.5',
        		'max'  => '100',
        		'step' => '0.5',
        		
        	),
        	'output' => array(
        		array(
        			'element'  => '.blog-masthead .gi-main-menu',
        			'property' => 'padding-left',
        			'suffix' => $navpad_suf_set,
        		),
        		array(
        			'element'  => '.blog-masthead .gi-main-menu',
        			'property' => 'padding-right',
        			'suffix' => $navpad_suf_set,
        		    ),
        	    ),
            ) 
        );





    /*
    ----------------------------
    
    SECTION: Color Controls
    
    ----------------------------

	---------------------------
	SUBSECTION 1: Palettes
	---------------------------
	*/   

    Kirki::add_section( 'color_palette', array(
        'title'          => esc_attr__( 'Core Color Palette', 'steel-theme' ),
        'description'    => esc_attr__( 'This is the color palette used used for the entire website. Sticking to one simple color palette creates an enjoyable and professional look. the colors you define here can be used in a variety of combinations in the "Color Palette Combinations" section.', 'steel-theme' ),
        'panel'          => 'design',
        'priority'       => 2,
        )
    );

        //  Color Palette 1
        Kirki::add_field( 'my_theme_config', array(
        	'type'        => 'color',
        	'settings'    => 'color_palette_c1',
        	'label'       => __( 'Color One', 'steel-theme' ),
        	'description' => esc_attr__( 'Select the first color in your color palette', 'steel-theme' ),
        	'section'     => 'color_palette',
        	'default'     => $themePaletteDefault[0],
        	'transport'   => 'refresh',
        	'choices'     => array(
        		'alpha' => true,
        		'palettes' => array(
        		    $colorOne
        		    ),
        	),
        	'output' => array(
        		array(
        			'element'  => '.iris-picker .iris-palette',
        			'property' => 'background-color',
        		    ),

        	    ),
            ) 
        );
        
        //  Color Palette 2
        Kirki::add_field( 'my_theme_config', array(
        	'type'        => 'color',
        	'settings'    => 'color_palette_c2',
        	'label'       => __( 'Color Two', 'steel-theme' ),
        	'description' => esc_attr__( 'Select the second color in your color palette', 'steel-theme' ),
        	'section'     => 'color_palette',
        	'default'     => $themePaletteDefault[1],
        	'transport'   => 'refresh',
        	'choices'     => array(
        		'alpha' => true,
        		'palettes' => array(
        		    $colorTwo
        		    ),
        	),
        	'output' => array(
        		array(
        			'element'  => '.iris-picker .iris-palette',
        			'property' => 'background-color',
        		    ),
        	    ),
            ) 
        );
        
        //  Color Palette 3
        Kirki::add_field( 'my_theme_config', array(
        	'type'        => 'color',
        	'settings'    => 'color_palette_c3',
        	'label'       => __( 'Color Three', 'steel-theme' ),
        	'description' => esc_attr__( 'Select the third color in your color palette', 'steel-theme' ),
        	'section'     => 'color_palette',
        	'default'     => $themePaletteDefault[2],
        	'transport'   => 'refresh',
        	'choices'     => array(
        		'alpha' => true,
        		'palettes' => array(
        		    $colorThree
        		    ),
        	),
        	'output' => array(
        		array(
        			'element'  => '.iris-picker .iris-palette',
        			'property' => 'background-color',
        		    ),
        	    ),
            ) 
        );

        //  Color Palette 4
        Kirki::add_field( 'my_theme_config', array(
        	'type'        => 'color',
        	'settings'    => 'color_palette_c4',
        	'label'       => __( 'Color Four', 'steel-theme' ),
        	'description' => esc_attr__( 'Select the fourth color in your color palette', 'steel-theme' ),
        	'section'     => 'color_palette',
        	'default'     => $themePaletteDefault[3],
        	'transport'   => 'refresh',
        	'choices'     => array(
        		'alpha' => true,
        		'palettes' => array(
        		    $colorFour
        		    ),
        	),
        	'output' => array(
        		array(
        			'element'  => '.iris-picker .iris-palette',
        			'property' => 'background-color',
        		    ),
        	    ),
            ) 
        );

        //  Color Palette 5
        Kirki::add_field( 'my_theme_config', array(
        	'type'        => 'color',
        	'settings'    => 'color_palette_c5',
        	'label'       => __( 'Color Fifth', 'steel-theme' ),
        	'description' => esc_attr__( 'Select the fifth color in your color palette', 'steel-theme' ),
        	'section'     => 'color_palette',
        	'default'     => $themePaletteDefault[4],
        	'transport'   => 'refresh',
        	'choices'     => array(
        		'alpha' => true,
        		'palettes' => array(
        		    $colorFive
        		    ),
        	),
        	'output' => array(
        		array(
        			'element'  => '.iris-picker .iris-palette',
        			'property' => 'background-color',
        		    ),
        	    ),
            ) 
        );
        
        //  Color Palette 6
        Kirki::add_field( 'my_theme_config', array(
        	'type'        => 'color',
        	'settings'    => 'color_palette_c6',
        	'label'       => __( 'High Contrast: Black (Text)', 'steel-theme' ),
        	'description' => esc_attr__( 'This swatch is reserved for black or a very dark gray that compliments the current palette. This will be the default text color in posts and can be used anytime a high-contrast dark color is needed.', 'steel-theme' ),
        	'section'     => 'color_palette',
        	'default'     => $themePaletteDefault[5],
        	'transport'   => 'refresh',
        	'choices'     => array(
        		'alpha' => true,
        		'palettes' => array(
        		    $colorSix
        		    ),
        	),
        	'output' => array(
        		array(
        			'element'  => '.iris-picker .iris-palette',
        			'property' => 'background-color',
        		    ),
        	    ),
            ) 
        );

        //  Color Palette 7
        Kirki::add_field( 'my_theme_config', array(
        	'type'        => 'color',
        	'settings'    => 'color_palette_c7',
        	'label'       => __( 'High Contrast: White (Post Background)', 'steel-theme' ),
        	'description' => esc_attr__( 'This swatch is reserved for white or a very light gray that compliments the current palette. This will be the default post background color in posts and can be used anytime a high-contrast light color is needed.', 'steel-theme' ),
        	'section'     => 'color_palette',
        	'default'     => $themePaletteDefault[6],
        	'transport'   => 'refresh',
        	'choices'     => array(
        		'alpha' => true,
        		'palettes' => array(
        		    $colorSeven
        		    ),
        	),
        	'output' => array(
        		array(
        			'element'  => '.iris-picker .iris-palette',
        			'property' => 'background-color',
        		    ),
        	    ),
            ) 
        );

        //  Reset switch
        Kirki::add_field( 'theme_config_id', array(
        	'type'        => 'switch',
        	'settings'    => 'color_palette_reset',
        	'label'       => __( 'Reset the Color Paette', 'steel-theme' ),
        	'description' => esc_attr__( 'This will restore the original theme default colors. NOTE: THIS WILL NOT SAVE OTHER CHANGES. If you have other changes that have not yet been saved, please click the Publish button first.', 'steel-theme' ),
        	'section'     => 'color_palette',
        	'default'     => 'off',
        	'priority'    => 10,
        	'transport'   => 'postMessage',
        	'choices'     => array(
        		'on'  => esc_attr__( 'Reset Palette', 'steel-theme' ),
        		'off' => esc_attr__( 'Reset Palett', 'steel-theme' ),
        	),
        ) );
        

    /*
	---------------------------
	SUBSECTION 2: Color Combinations
	---------------------------
	*/        

    Kirki::add_section( 'color_combinations', array(
        'title'          => esc_attr__( 'Color Combinations', 'steel-theme' ),
        'description'    => esc_attr__( 'Here the Color Palett colors are used in a variety combinations. Each utilizes a diffeerent appraoch and will provide a unique look and feel.', 'steel-theme' ),
        'panel'          => 'design',
        'priority'       => 2,
        )
    );
        
        //  Color Sets
        Kirki::add_field( 'theme_config_id', array(
        	'type'        => 'palette',
        	'settings'    => 'my_setting',
        	'label'       => __( 'Palette Control', 'steel-theme' ),
        	'section'     => 'color_combinations',
        	'default'     => 'Color Set 1',
        	'priority'    => 10,
        	'choices'     => array(
        		'Color Set 1' => array(
        		    
        			$colorOne,
        			$colorTwo,
        			$colorThree,
        			$colorFour,
        			$colorFive,
        			$colorSix,
        			$colorSeven,
        			
        		),
        		
        		'Color Set 2' => array(
        		    
        			$colorOne,
        			$colorTwo,
        			$colorThree,
        			$colorFour,
        			$colorFive,
        			$colorSix,
        			$colorSeven,
        			
        		),
        		
        		'Color Set 3' => array(
    		    
        			$colorOne,
        			$colorTwo,
        			$colorThree,
        			$colorFour,
        			$colorFive,
        			$colorSix,
        			$colorSeven,
    			
    		    ),
        		
        		'Color Set 4' => array(
		    
        			$colorOne,
        			$colorTwo,
        			$colorThree,
        			$colorFour,
        			$colorFive,
        			$colorSix,
        			$colorSeven,
			
		        ),
		        
		        'Color Set 5' => array(
		    
        			$colorOne,
        			$colorTwo,
        			$colorThree,
        			$colorFour,
        			$colorFive,
        			$colorSix,
        			$colorSeven,
			
		        ), 
        	  ),
            )
        );

    /*
    ----------------------------
    
    Panel: Branding and Graphics
    
    ----------------------------
	*/
	
    Kirki::add_section( 'branding_and_graphics', array(
        'title'          => esc_attr__( 'Branding and Graphics', 'steel-theme' ),
        'description'    => esc_attr__( 'Branding and Graphics.', 'steel-theme' ),
        'panel'          => 'design',
        'priority'       => 10,
        )
    );
    
    //  Main Welcome Image
    Kirki::add_field( 'my_theme_config', array(
    	'type'        => 'image',
    	'settings'    => 'theme_welcome_image',
    	'label'       => esc_attr__( 'Site-Wide Welcome Image', 'steel-theme' ),
    	'description' => esc_attr__( 'This image will appear at as a default image at the top of each page as part of a page greeting along with the page title and description, if available. Each page can have it\'s own unique Welcome Image which is set in the Page Editor. Otherwise, this default image will be used.', 'steel-theme' ),
    	'section'     => 'branding_and_graphics',
    	'default'     => '',
    	'transport'   => 'refresh',
    	
        )
    );
    
    //  Logo image
    Kirki::add_field( 'my_theme_config', array(
    	'type'        => 'image',
    	'settings'    => 'theme_logo_image',
    	'label'       => esc_attr__( 'Logo Image', 'steel-theme' ),
    	'description' => esc_attr__( 'This image is best around 500px X 500px. Other sizes are fine, but square s best.', 'steel-theme' ),
    	'section'     => 'branding_and_graphics',
    	'default'     => '',
    	'transport'   => 'refresh',
    	
        )
    );
    
    //  Logo adjustment - size
    Kirki::add_field( 'my_theme_config', array(
    	'type'        => 'slider',
    	'settings'    => 'theme_logo_image_size',
    	'label'       => __( 'Logo Size Adjustment', 'steel-theme' ),
    	'description' => esc_attr__( ': Move the slider to increase or decrease the logo size.', 'steel-theme' ),
    	'section'     => 'branding_and_graphics',
    	'default'     => '5',
    	'choices'     => array(
    		'min'  => '5',
    		'max'  => '25',
    		'step' => '1',
    		
    	),
    	'output' => array(
    		array(
    			'element'  => '#nav-logo',
    			'property' => 'width',
    			'suffix' => '%',
    			'element'  => '#nav-logo',
    			'property' => 'height',
    			'suffix' => '%',
    		),
    		array(
    			'element'  => '#nav-logo',
    			'property' => 'height',
    			'suffix' => '%',
    		),
    		array(
    			'element'  => '#nav-logo',
    			'property' => 'padding',
    			'suffix' => '%',
    		    ),
    	    ),
        )
    );
    
    //  Logo adjustment - position
    Kirki::add_field( 'my_theme_config', array(
    	'type'        => 'slider',
    	'settings'    => 'theme_logo_image_position',
    	'label'       => __( 'Logo Fine Adjustment', 'steel-theme' ),
    	'description' => esc_attr__( ': Move the slider to raise or lower the logo.', 'steel-theme' ),
    	'section'     => 'branding_and_graphics',
    	'default'     => '0',
    	'choices'     => array(
    		'min'  => '-50',
    		'max'  => '50',
    		'step' => '1',
    	),
    	'output' => array(
    		array(
    			'element'  => '#nav-logo',
    			'property' => 'transform',
    			'prefix' => 'translateY(',
    			'suffix' => 'px)',
    		    ),
    	    ),
        )
    );
    
    //  Logo image adjustment - margin right
    Kirki::add_field( 'my_theme_config', array(
    	'type'        => 'slider',
    	'settings'    => 'theme_logo_image_margin_right',
    	'label'       => __( 'Logo Right Spacing', 'steel-theme' ),
    	'description' => esc_attr__( ': Move the slider to adjust the spacing ont eh right of teh logo.', 'steel-theme' ),
    	'section'     => 'branding_and_graphics',
    	'default'     => '7',
    	'choices'     => array(
    		'min'  => '0',
    		'max'  => '10',
    		'step' => '1',
    		
    	),
    	'output' => array(
    		array(
    			'element'  => '#nav-logo',
    			'property' => 'margin-right',
    			'suffix' => 'px',
    		    ),
    	    ),
        )
    );

} //End the check to see if the Kirki plugin is active. this is also the end of the Controls section





/******************************
*
*       Add to Document
*
*******************************/

/*
----------------------------

Add CSS and JS to Doc Head

----------------------------
*/

function customizer_data_for_head() {
    
    // Default color palette
    $themePaletteDefault = array(
                        	$colorOne = '#0c0c0c' ,
                        	$colorTwo = '#d1d1d1',
                        	$colorThree = '#e0e0e0',
                        	$colorFour = '#324042',
                        	$colorFive = '#0494db',
                        	$colorSix = '#e0e0e0',
                        	$colorSeven = '#353336',
    	
    );

			
    // Detect chosen palette combination and set the colors to variables 
    $saved_palette = get_theme_mod( 'my_setting', 'Color Set 1' );
    $colorOne = get_theme_mod( 'color_palette_c1', $themePaletteDefault[0] );
    $colorTwo = get_theme_mod( 'color_palette_c2', $themePaletteDefault[1] );
    $colorThree = get_theme_mod( 'color_palette_c3', $themePaletteDefault[2] );
    $colorFour = get_theme_mod( 'color_palette_c4', $themePaletteDefault[3] );
    $colorFive = get_theme_mod( 'color_palette_c5', $themePaletteDefault[4] );
    $colorSix = get_theme_mod( 'color_palette_c6', $themePaletteDefault[5] );
    $colorSeven = get_theme_mod( 'color_palette_c7', $themePaletteDefault[6] );


    if ( 'Color Set 1' == $saved_palette ) {
        
    	$background1   =    $colorOne;
    	$text_color1   =    $colorTwo;
    	$background2   =    $colorTwo;
    	$text_color2   =    $colorOne;
    	$background3   =    $colorFour;
    	$text_color3   =    $colorSix;
    	$background4   =    $colorThree;
    	$text_color4   =    $colorOne;
    	$background5   =    $colorTwo;
    	$text_color5   =    $colorSeven;
    	
    } else if ( 'Color Set 2' == $saved_palette ) {
        
     	$background1   =    $colorTwo;
    	$text_color1   =    $colorOne;
    	$background2   =    $colorOne;
    	$text_color2   =    $colorTwo;
    	$background3   =    $colorThree;
    	$text_color3   =    $colorSix;
    	$background4   =    $colorFour;
    	$text_color4   =    $colorOne;
    	$background5   =    $colorOne;
    	$text_color5   =    $colorSeven;
    	
    } else if ( 'Color Set 3' == $saved_palette ) {
        
     	$background1   =    $colorThree;
    	$text_color1   =    $colorSeven;
    	$background2   =    $colorFour;
    	$text_color2   =    $colorSeven;
    	$background3   =    $colorTwo;
    	$text_color3   =    $colorOne;
    	$background4   =    $colorOne;
    	$text_color4   =    $colorTwo;
    	$background5   =    $colorTwo;
    	$text_color5   =    $colorThree;
    	
    } else if ( 'Color Set 4' == $saved_palette ) {
     	$background1   =    $colorFour;
    	$text_color1   =    $colorSix;
    	$background2   =    $colorSix;
    	$text_color2   =    $colorFour;
    	$background3   =    $colorFour;
    	$text_color3   =    $colorSix;
    	$background4   =    $colorSix;
    	$text_color4   =    $colorFive;
    	$background5   =    $colorFour;;
    	$text_color5   =    $colorSeven;
    	
    } else if ( 'Color Set 5' == $saved_palette ) {
        
     	$background1   =    $colorSeven;
    	$text_color1   =    $colorSix;
    	$background2   =    $colorSix;
    	$text_color2   =    $colorSeven;
    	$background3   =    $colorFive;
    	$text_color3   =    $colorSeven;
    	$background4   =    $colorSeven;
    	$text_color4   =    $colorSix;
    	$background5   =    $colorSix;
    	$text_color5   =    $colorSeven;
    }
    
    
    $colorCombo1 = "background-color:$background1; color:$text_color1;";
    $colorCombo2 = "background-color:$background2; color:$text_color2;";
    $colorCombo3 = "background-color:$background3; color:$text_color3;";
    $colorCombo4 = "background-color:$background4; color:$text_color4;";
    $colorCombo5 = "background-color:$background5; color:$text_color5;";
    ?>

    <style type="text/css">
            
        <?php
        // The following function I modified, but the original work is from https://css-tricks.com/snippets/php/convert-hex-to-rgb/
        function hex2rgb( $colour ) {
            
            if ( $colour[0] == '#' ) {
                
                    $colour = substr( $colour, 1 );
                    
            }
    
            if ( strlen( $colour ) == 6 ) {
                
                    list( $r, $g, $b ) = array( $colour[0] . $colour[1], $colour[2] . $colour[3], $colour[4] . $colour[5] );
                    
            } elseif ( strlen( $colour ) == 3 ) {
                
                    list( $r, $g, $b ) = array( $colour[0] . $colour[0], $colour[1] . $colour[1], $colour[2] . $colour[2] );
                    
            } else {
                
                    return false;
                    
            }
            
            $r = hexdec( $r );
            $g = hexdec( $g );
            $b = hexdec( $b );
            
            return $r .','. $g .','.  $b ;
        }
    
        
        function set_css_gradient_top( $color ) {

            $colorRGB = hex2rgb($color);    
           
            return '
            /* Permalink - use to edit and share this gradient: http://colorzilla.com/gradient-editor/#5fa9bc+0,5fa9bc+50&0+0,0.05+10,1+25,1+75,1+100 */ 
            background: -moz-linear-gradient(top, rgba('.$colorRGB.',0) 0%,rgba('.$colorRGB.',0.05) 10%,rgba('.$colorRGB.',0.95) 90%,rgba('.$colorRGB.',1) 100%); /* FF3.6-15 */
            background: -webkit-linear-gradient(top, rgba('.$colorRGB.',0) 0%,rgba('.$colorRGB.',0.05) 10%,rgba('.$colorRGB.',0.95) 90%,rgba('.$colorRGB.',1) 100%); /* Chrome10-25,Safari5.1-6 */
            background: linear-gradient(to bottom, rgba('.$colorRGB.',0) 0%,rgba('.$colorRGB.',0.05) 10%,rgba('.$colorRGB.',0.95) 90%,rgba('.$colorRGB.',1) 100%); /* W3C, IE10+, FF16+, Chrome26+, Opera12+, Safari7+ */
            ';   
        }
        
        function set_css_gradient( $color ) {
            
            $colorRGB = hex2rgb($color);
            
            return 'background: -moz-linear-gradient(top, rgba('.$colorRGB.',0) 0%, rgba('.$colorRGB.',0.05) 10%, rgba('.$colorRGB.',1) 25%, rgba('.$colorRGB.',1) 50%, rgba('.$colorRGB.',1) 75%, rgba('.$colorRGB.',0.05) 90%, rgba('.$colorRGB.',0) 100%);
                background: -webkit-linear-gradient(top, rgba('.$colorRGB.',0) 0%,rgba('.$colorRGB.',0.05) 10%,rgba('.$colorRGB.',1) 25%,rgba('.$colorRGB.',1) 50%,rgba('.$colorRGB.',1) 75%,rgba('.$colorRGB.',0.05) 90%,rgba('.$colorRGB.',0) 100%);
                background: linear-gradient(to bottom, rgba('.$colorRGB.',0) 0%,rgba('.$colorRGB.',0.05) 10%,rgba('.$colorRGB.',1) 25%,rgba('.$colorRGB.',1) 50%,rgba('.$colorRGB.',1) 75%,rgba('.$colorRGB.',0.05) 90%,rgba('.$colorRGB.',0) 100%);
                    background-color: rgba(0, 0, 0, 0);
                ';
        }
        
        function set_css_gradient_bottom( $color ) {
            
            $colorRGB = hex2rgb($color);    
           
            return '
            /* Permalink - use to edit and share this gradient: http://colorzilla.com/gradient-editor/#5fa9bc+0,5fa9bc+50&0+0,0.05+10,1+25,1+75,1+100 */ 
            background: -moz-linear-gradient(bottom, rgba('.$colorRGB.',0) 0%,rgba('.$colorRGB.',0.05) 10%,rgba('.$colorRGB.',0.95) 90%,rgba('.$colorRGB.',1) 100%); /* FF3.6-15 */
            background: -webkit-linear-gradient(bottom, rgba('.$colorRGB.',0) 0%,rgba('.$colorRGB.',0.05) 10%,rgba('.$colorRGB.',0.95) 90%,rgba('.$colorRGB.',1) 100%); /* Chrome10-25,Safari5.1-6 */
            background: linear-gradient(to top, rgba('.$colorRGB.',0) 0%,rgba('.$colorRGB.',0.05) 10%,rgba('.$colorRGB.',0.95) 90%,rgba('.$colorRGB.',1) 100%); /* W3C, IE10+, FF16+, Chrome26+, Opera12+, Safari7+ */
            ';   
        }
        
        
        function set_css_gradient_2( $color ) {
            
            $colorRGB = hex2rgb($color);    
           
            return '
            /* Permalink - use to edit and share this gradient: http://colorzilla.com/gradient-editor/#5fa9bc+0,5fa9bc+50&0+0,0.05+10,1+25,1+75,1+100 */ 
            background: -moz-linear-gradient(top, rgba('.$colorRGB.',0) 0%, rgba('.$colorRGB.',0.05) 10%, rgba('.$colorRGB.',1) 25%, rgba('.$colorRGB.',1) 50%, rgba('.$colorRGB.',1) 75%, rgba('.$colorRGB.',1) 100%); /* FF3.6-15 */
            background: -webkit-linear-gradient(top, rgba('.$colorRGB.',0) 0%,rgba('.$colorRGB.',0.05) 10%,rgba('.$colorRGB.',1) 25%,rgba('.$colorRGB.',1) 50%,rgba('.$colorRGB.',1) 75%,rgba('.$colorRGB.',1) 100%); /* Chrome10-25,Safari5.1-6 */
            background: linear-gradient(to bottom, rgba('.$colorRGB.',0) 0%,rgba('.$colorRGB.',0.05) 10%,rgba('.$colorRGB.',1) 25%,rgba('.$colorRGB.',1) 50%,rgba('.$colorRGB.',1) 75%,rgba('.$colorRGB.',1) 100%); /* W3C, IE10+, FF16+, Chrome26+, Opera12+, Safari7+ */
            ';   
        }
        
        
        function set_css_gradient_3( $color ) {
            
            $colorRGB = hex2rgb($color);    
           
            return '
                    background-image: -webkit-radial-gradient(center, ellipse cover, rgba('.$colorRGB.', 0.5) 10%, rgba('.$colorRGB.', .5) 20%, rgba('.$colorRGB.', .5) 30%, rgba('.$colorRGB.', 0.5) 100%);
                    background-image: -moz-radial-gradient(center, ellipse cover, rgba('.$colorRGB.', 0.5) 10%, rgba('.$colorRGB.', .5) 20%, rgba('.$colorRGB.', .5) 30%, rgba('.$colorRGB.', 0.5) 100%);
                    background-image: radial-gradient(ellipse at center, rgba('.$colorRGB.', 0.5) 10%, rgba('.$colorRGB.', .5) 20%, rgba('.$colorRGB.', .5) 30%, rgba('.$colorRGB.', 0.5) 100%);
            ';   
        }
    
        ?>
        
        body {<?php echo $colorCombo1 ?>}
        
         ::-webkit-scrollbar-thumb {background: <?php echo     $text_color1     ?> ;}
         
         ::-webkit-scrollbar-track {background: <?php echo     $background1    ?> ;}
    
        .color-footer {<?php echo     $colorCombo2    ?>}
        
        .color-footer-grad.grad-top { <?php echo set_css_gradient_top( $background3 ) ?>}
        
        .color-footer-grad { <?php echo $colorCombo3, set_css_gradient_2( $background3 ) ?>}
        
        .color-footer-grad.grad-bottom { <?php echo set_css_gradient_bottom( $background3 ) ?>}
        
        #pre-footer-section.color4 {<?php echo     $colorCombo4    ?>}
        
        #pre-footer-gradtop.color4-grad.grad-top { <?php echo set_css_gradient_top( $background4 ) ?>}
        
        #pre-footer-section.color4-grad { <?php echo set_css_gradient_2( $background4 ) ?>}
        
        #pre-footer-gradbottom.color4-grad.grad-bottom { <?php echo set_css_gradient_bottom( $background4 ) ?>}
        
        .container.top-menu:before, .container.top-menu .menu-title  {<?php echo     $colorCombo2    ?>}
        
        #welcome-image #grad-box-1 {background-color: <?php echo     $background1    ?>; color:<?php echo     $background1    ?>;}
        
        .single .entry-content, .single .postnav-outerwrap {color: <?php echo     $colorSeven     ?> ;}
        
        .color1 {<?php echo     $colorCombo1    ?>}
        
        .color1-grad.grad-top { <?php echo set_css_gradient_top( $background1 ) ?>}
        
        .color1-grad { <?php echo set_css_gradient( $background1 ) ?>}
        
        .color1-grad.grad-bottom { <?php echo set_css_gradient_bottom( $background1 ) ?>}
    
        .color2 {<?php echo     $colorCombo2    ?>}
        
        .color2-grad.grad-top { <?php echo set_css_gradient_top( $background2 ) ?>}
        
        .color2-grad { <?php echo set_css_gradient( $background2 ) ?>}
        
        .color2-grad.grad-bottom { <?php echo set_css_gradient_bottom( $background2 ) ?>}
        
        
        .color3 {<?php echo     $colorCombo3    ?>}
        
        .color3-grad.grad-top { <?php echo set_css_gradient_top( $background3 ) ?>}
        
        .color3-grad { <?php echo set_css_gradient( $background3 ) ?>}
        
        .color3-grad.grad-bottom { <?php echo set_css_gradient_bottom( $background3 ) ?>}
        
        .color4 {<?php echo     $colorCombo4    ?>}
        
        .color4-grad.grad-top { <?php echo set_css_gradient_top( $background4 ) ?>}
        
        .color4-grad { <?php echo set_css_gradient( $background4 ) ?>}
        
        .color4-grad.grad-bottom { <?php echo set_css_gradient_bottom( $background4 ) ?>}
        
        .color5 {<?php echo     $colorCombo5    ?>}
        
        .color5-grad.grad-top { <?php echo set_css_gradient_top( $background5 ) ?>}
        
        .color5-grad { <?php echo set_css_gradient( $background5 ) ?>}
        
        .color5-grad.grad-bottom { <?php echo set_css_gradient_bottom( $background5 ) ?>}
        
        <?php $image = get_theme_mod( 'theme_welcome_image', '' ); ?>
        
        #welcome-image { background-image: url('<?php echo esc_url( $image ); ?>')}

    </style>
         
     <?php 
    // Set the js variable for the admin bar 
    if (true == get_theme_mod( 'top-bar-toggle', true )) {
        
        $top_bar_setting = get_theme_mod( 'top-bar-toggle', true );
        
    } else {$top_bar_setting = 0;}
    
    ?>
    <script>
    
        var topBarSetting = <?php echo $top_bar_setting ?>;
        
    </script>

<?php
 
}  //  END customizer_data_for_head

add_action( 'wp_head', 'customizer_data_for_head');

?>

<?php

//  This function will be used to "live-update" PHP on customizer refresh as the Customizer grows
function preview_updater() {
    

}
add_action( 'customize_preview_init', 'preview_updater', 21 );






function gicp_update_palette() {
    
        global $wpdb;
        global$themePaletteDefault;

        $palette_name = 'custom';

        //  Grab the custom palette colors if 
        //  they exists. Otherwise use the default palette.
        $colorOne = get_theme_mod( 'color_palette_c1', $themePaletteDefault[0] );
        $colorTwo = get_theme_mod( 'color_palette_c2', $themePaletteDefault[1] );
        $colorThree = get_theme_mod( 'color_palette_c3', $themePaletteDefault[2] );
        $colorFour = get_theme_mod( 'color_palette_c4', $themePaletteDefault[3] );
        $colorFive = get_theme_mod( 'color_palette_c5', $themePaletteDefault[4] );
        $colorSix = get_theme_mod( 'color_palette_c6', $themePaletteDefault[5] );
        $colorSeven = get_theme_mod( 'color_palette_c7', $themePaletteDefault[6] );
            	
    	$table_name = $wpdb->prefix . 'color_palettes';


        $wpdb->update( 
    		$table_name, 
    		array(
    		    
    			'time'   => current_time( 'mysql' ),
    			'color1' => $colorOne,
    			'color2' => $colorTwo,
    			'color3' => $colorThree,
    			'color4' => $colorFour,
    			'color5' => $colorFive,
    			'color6' => $colorSix,
    			'color7' => $colorSeven,

            ),

            array( 'ID' => 2 ), 
        	array( 
        		'%s',	// value1
        		'%s',	// value2
        		'%s',	// value3
        		'%s',	// value4
        		'%s',	// value5
        		'%s',	// value6
        		'%s',	// value7
        		'%s'	// value8
        	), 
        	
        	array( '%d' ) 
                    );
}

add_action( 'customize_save_after', 'gicp_update_palette' );


function gicp_reset_palette() {
    
        global $wpdb;
        global$themePaletteDefault;

        $palette_name = 'custom';

        //  Grab the default palette colors
        $colorOne = $themePaletteDefault[0];
        $colorTwo = $themePaletteDefault[1];
        $colorThree = $themePaletteDefault[2];
        $colorFour = $themePaletteDefault[3];
        $colorFive = $themePaletteDefault[4];
        $colorSix = $themePaletteDefault[5];
        $colorSeven = $themePaletteDefault[6];
        
        //  Reset the theme_mod data
        set_theme_mod( 'color_palette_c1', $colorOne );
        set_theme_mod( 'color_palette_c2', $colorTwo );
        set_theme_mod( 'color_palette_c3', $colorThree );
        set_theme_mod( 'color_palette_c4', $colorFour );
        set_theme_mod( 'color_palette_c5', $colorFive );
        set_theme_mod( 'color_palette_c6', $colorSix );
        set_theme_mod( 'color_palette_c7', $colorSeven );
           
        //  Update the color_palette DB table
    	$table_name = $wpdb->prefix . 'color_palettes';
    	
        $wpdb->update( 
    		$table_name, 
    		array(
    		    
    			'time'   => current_time( 'mysql' ),
    			'color1' => $colorOne,
    			'color2' => $colorTwo,
    			'color3' => $colorThree,
    			'color4' => $colorFour,
    			'color5' => $colorFive,
    			'color6' => $colorSix,
    			'color7' => $colorSeven,

            ),

            array( 'ID' => 2 ),
            
        	array( 
        		'%s',	// value1
        		'%s',	// value2
        		'%s',	// value3
        		'%s',	// value4
        		'%s',	// value5
        		'%s',	// value6
        		'%s',	// value7
        		'%s'	// value8
        	), 
        	
        	array( '%d' ) 
                    );
}


?>



