
<?php
/**
 * The index template file
 *
 * @package WordPress
 * @subpackage Human Connection
 * @since 1.0
 * @version 1.0
 */
 ?>
 <?php  function check_page_type($desired_output) {
    if ($desired_output == 'title'){if (is_home()) { 

            	$output = bloginfo('name');
            	return $output;
            
            } else { 
            
                $output = the_title();
                return $output;
            }
        
    }
    if ($desired_output == 'desc') {
        if (is_home()) { 

            	$output = bloginfo('description');
            	
            	return $output;
            
            } else { 
                
            	$output = get_the_excerpt();
            	echo 'output: ';
            	return $output;
            }
    }
            
            
}
?>
             
             
<?php get_header(); ?>
<div id="index-page" class="handwriting">
    
    
    <!-- ***************************************************************************************  -->
    <!-- ************************************* Section: Top ************************************  -->
    <!-- ***************************************************************************************  -->
    <div id="top-section" class="row section top-section-wrap color1">
        <div id="page-title-wrap" class="title-wrap">
            <div id="page-title">
                <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
                   <?php  check_page_type('title');?>
                </a>
            </div><!-- END #page-title -->
            <div id="page-desc" class="page-desc">
                <h3><?php  $meta_key = 'smashing_post_class';
                            echo get_post_meta( $post->ID, $meta_key, true ); ?>
                </h3>
            </div>
        </div><!-- END #page-title-wrap -->
        <div class="image-wrap">
            <div class="image-acent color4-grad-radial"></div>
            <div id="welcome-image">
                <div id="grad-box-1" class="color2"></div>
            </div>
        </div>
    </div><!-- END #top-section -->
    <div id="top-section-gradbottom" class="grad-bottom color1 color1-grad zindex10"></div>
    
    
    <!-- ***************************************************************************************  -->
    <!-- ************************************* Section: Main ************************************  -->
    <!-- ***************************************************************************************  -->
    <div id="main-section-gradtop" class="grad-top color2 color2-grad zindex10"></div>
    <div id="main-section" class="section row color2 zindex10">

        <div id="main-content" class="main-content">
            
        	<div id="primary" class="content-area">
        	    
        		<div id="content" class="site-content" role="main">
        		    
        		    <div id="ms-container">
        		        
        		        <div id="masonry-loop">
        		    
            	    <!-- ******************* The loop *******************  -->  
                    <?php 
                        // Loop criteria
                        $args= array(
                                        'post_type'      => 'post',
                                        'paged' => $paged,
                                        'posts_per_page' =>  10
                                    );
                
                        $query = new WP_Query($args); 

        			    // Start the Loop.
        			    while ( have_posts() ) :
        				    the_post();
        		    ?>
        		            <!-- Set the unique post ID and class -->
        				    <article id="post-<?php the_ID(); ?>"
        				                    <?php post_class('ms-item clearfix'); ?>
        				    >
        				        
                            	<?php
                            	// Page thumbnail and title
                            	the_post_thumbnail();
                            	
                            	?>
                            	<header class="entry-header">
                            	    <h1 class="entry-title">
                                        <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" >
                                        <?php
                                    	the_title();
                                    	?>
                                        </a>
                                    </h1>
                                </header><!-- .entry-header -->
                            	<div class="entry-content clearfix">
                            		<?php
                                		// Post body content
                            			the_content();
                            			?>
                            			
                            			By <?php the_author_posts_link(); ?> on <?php the_time('F jS, Y'); ?>  in <div class="cat-tag-wrap"> <?php the_category(', '); ?>. </div>
                            			    <br><strong>Tags</strong><div class="cat-tag-wrap"><?php the_tags( '' , ', '); ?></div>
                            			
                            			<?php
                            			edit_post_link( __( 'Edit', 'human-connection' ), '<span class="edit-link">', '</span>' );
                            		?>
                            		
                                </div><!-- .entry-content -->
                                
                                <?php pagenav_standard() ?>

                                
                            </article><!-- #post-## -->
                            <?php
                				// If comments are open or we have at least one comment, load up the comment template.
                				if ( comments_open() || get_comments_number() ) {
                					comments_template();
                				}
                				
        				endwhile;
        			        ?>
        		<!-- ******************* /END The loop ******************* -->
        		        
        		        </div><!--/#masonry-loop-->
        		        
        		    </div><!-- #ms-container -->
        		    
        		</div><!-- #content -->
        		
        	</div><!-- #primary -->
        	
        </div><!-- /END #main-content -->
   
    </div><!-- /END #main-section -->
    <div id="main-section-gradbottom" class="grad-bottom color2 color2-grad zindex10"></div>
    
    
    
    <!-- ***************************************************************************************  -->
    <!-- ****************************** Section: Pre-Footer ************************************  -->
    <!-- ***************************************************************************************  -->
    <div id="pre-footer-gradtop" class="grad-top color3 color3-grad zindex10"></div>
    <div id="pre-footer-section" class="section row color3 zindex10">
        
            <div id="footer-center-wrap" class="center-wrap">
                
                <div id="footer-form" class="contact-form handwriting"> 
                    <?php include('contact_form.php'); ?>
                </div><!-- END #footer-form -->
                
            </div><!-- END #footer-center-wrap -->
            
    </div><!-- END #pre-footer-section -->
    <div id="pre-footer-gradbottom" class="grad-bottom color3 color3-grad zindex10"></div>

    <div id="fixed-form-wrap" class="trans-ease75">
    </div><!-- END #fixed-form-wrap -->
    
</div><!-- END #standard-page -->


 <script type="text/javascript">
        
        jQuery(window).load(function() {
      var container = document.querySelector('#ms-container');
      var msnry = new Masonry( container, {
        itemSelector: '.ms-item',
        columnWidth: '.ms-item',                
      });  
      
        });

      
    </script>





    
<?php get_footer(); ?>