<?php
/*
*
*  Meta boxes for the page editor
*
*/
?>


<?php

//******************************************************************************
//    The following is listed only to show the anatomy of this process.
//******************************************************************************
// From: https://smashingmagazine.com/2011/10/create-custom-post-meta-boxes-wordpress/ 

function my_test_function() {
// Fire our meta box setup function on the post editor screen.
add_action( 'load-post.php', 'gi_page_meta_boxes_setup' );
add_action( 'load-post-new.php', 'gi_page_meta_boxes_setup' );

// Meta box setup function
function gi_page_meta_boxes_setup() {

  //Add meta boxes on the 'add_meta_boxes' hook
  add_action( 'add_meta_boxes', 'gi_add_page_meta_boxes' );

  //Save post meta on the 'save_post' hook
  add_action( 'save_post', 'gi_save_page_class_meta', 10, 2 );
}


// Create one or more meta boxes to be displayed on the post editor screen
function gi_add_page_meta_boxes() {
    
    $screens = array( 'post', 'page', 'book' );
    
    add_meta_box(
        'gi-main-desc',      // Unique ID
        esc_html__( 'Subtitle', 'example' ),    // Title
        'gi_page_class_meta_box',   // Callback function
        $screens,         // Admin page (or post type)
        'gi_after_title',         // Context
        'default'         // Priority
    );
}

// Display the post meta box
function gi_page_class_meta_box( $post ) { ?>

  <?php wp_nonce_field( basename( __FILE__ ), 'smashing_post_class_nonce' ); ?>

    <p>
    <label for="gi-main-desc"><?php _e( "<p>This will be displayed right below the title. This field is recommended, but optional. Text only, please, as this field will not accept HTML.</p>", 'human-connection' ); ?></label>
    <br />
    <input class="widefat" type="text" name="gi-main-desc" id="gi-main-desc" value="<?php echo esc_attr( get_post_meta( $post->ID, 'smashing_post_class', true ) ); ?>" size="30" />
  </p>
<?php }

// Save the meta box's post metadata
function gi_save_page_class_meta( $post_id, $post ) {

  /* Verify the nonce before proceeding. */
  if ( !isset( $_POST['smashing_post_class_nonce'] ) || !wp_verify_nonce( $_POST['smashing_post_class_nonce'], basename( __FILE__ ) ) )
    return $post_id;

  /* Get the post type object. */
  $post_type = get_post_type_object( $post->post_type );

  /* Check if the current user has permission to edit the post. */
  if ( !current_user_can( $post_type->cap->edit_post, $post_id ) )
    return $post_id;

  /* Get the posted data and sanitize it for use as an HTML class. */
  $new_meta_value = ( isset( $_POST['gi-main-desc'] ) ? wp_strip_all_tags( $_POST['gi-main-desc'] ) : '' );

  /* Get the meta key. */
  $meta_key = 'smashing_post_class';

  /* Get the meta value of the custom field key. */
  $meta_value = get_post_meta( $post_id, $meta_key, true );

  /* If a new meta value was added and there was no previous value, add it. */
  if ( $new_meta_value && '' == $meta_value )
    add_post_meta( $post_id, $meta_key, $new_meta_value, true );

  /* If the new meta value does not match the old value, update it. */
  elseif ( $new_meta_value && $new_meta_value != $meta_value )
    update_post_meta( $post_id, $meta_key, $new_meta_value );

  /* If there is no new meta value but an old value exists, delete it. */
  elseif ( '' == $new_meta_value && $meta_value )
    delete_post_meta( $post_id, $meta_key, $meta_value );
}

};



//********************** Begin Meta Boxes *************************************




function meta_panel_script_add() { ?>

    <script>
    
    jQuery( document ).ready(function() {
        
            jQuery('button.handlediv').on('click', function() { 
                
                var theParent = jQuery(this).closest('.handlediv'); 
                
                jQuery(theParent).siblings('.inside').toggle();
                
                jQuery(this).toggleClass('opened-meta-box');
                
            });
    });
    
    function waitForElement(elementPath, callBack){
        
      window.setTimeout(function(){
          
        if($(elementPath).length){
            
          callBack(elementPath, $(elementPath));
          
        }else{
            
          waitForElement(elementPath, callBack);
          
        }
      },500);
    }
    </script>
    
    <script> 
        jQuery( window ).load(function() {
            
            jQuery('.meta-panel-wrap').prepend('<div class="close-btn"></div>');
            
            jQuery('.meta-box-head, .meta-panel-wrap .close-btn').on('click', function() { 
                
                    var theChildren = jQuery(this).siblings('.meta-panel-component'); 
                    
                    var thisCheck = jQuery(this).hasClass( "meta-panel-wrap" );
                    
                    if (thisCheck) {
                        jQuery(this).toggleClass('opened-meta-wrap');
                        
                    } else {
                        
                        jQuery(this).closest('.meta-panel-wrap').toggleClass('opened-meta-wrap');
                        
                    }
                });
                
            (function( $ ) {
         
                // Add Color Picker to all inputs that have 'color-field' class
                $(function() {
                    $('.color-field').wpColorPicker();
                });
             
            })( jQuery );
    
    
        });
    </script>
    
    <?php 
    //  Make the default color palette available
    global $themePaletteDefault;
    ?>
    
    <script>
        jQuery( document ).ready(function() {
            var colorOne = "<?php echo get_theme_mod( 'color_palette_c1', $themePaletteDefault[0] )?>";
            var colorTwo = "<?php echo get_theme_mod( 'color_palette_c2', $themePaletteDefault[1] )?>";
            var colorThree = "<?php echo get_theme_mod( 'color_palette_c3', $themePaletteDefault[2] )?>";
            var colorFour = "<?php echo get_theme_mod( 'color_palette_c4', $themePaletteDefault[3] )?>";
            var colorFive = "<?php echo get_theme_mod( 'color_palette_c5', $themePaletteDefault[4] )?>";
            var colorSix = "<?php echo get_theme_mod( 'color_palette_c6', $themePaletteDefault[5] )?>";
            var colorSeven = "<?php echo get_theme_mod( 'color_palette_c7', $themePaletteDefault[6] )?>";
                    
                        // This variable is global to allow use accross the document including customizer.js
            giThemeColorPalette = [
                                    colorOne,
                                    colorTwo,
                                    colorThree,
                                    colorFour,
                                    colorFive,
                                    colorSix,
                                    colorSeven
                                  ];

        }); // END document ).ready   


    </script>
    
<?php
} 
 add_action( 'admin_print_footer_scripts', 'meta_panel_script_add');
 


 
//******************************************************************************
//                            Meta Panel Subtitle
//******************************************************************************
//******************************************************************************
function meta_panel_wrapper_one() { ?>
    <script>jQuery( document ).ready(function() {
        jQuery('.meta-panel-subtitle').wrapAll( "<div class='meta-panel-wrap meta-panel-subtitle-wrap opened-meta-wrap' />").closest('.meta-panel-wrap').prepend('<div class="meta-box-head">Page Subtitle</div>');
        jQuery('.meta-panel-subtitle').wrapAll('<div class="metabox-section" />');
    });</script>
<?php
} 
 add_action( 'admin_print_footer_scripts', 'meta_panel_wrapper_one');
//******************************************************************************
//                  Custom Meta 1 " Page Subtitle "
//******************************************************************************

                                                // Edit within these boxes only
                                                //****************************
add_action( 'load-post.php',                    'gi_page_meta_boxes_setup' );
add_action( 'load-post-new.php',                'gi_page_meta_boxes_setup' );
function                                        gi_page_meta_boxes_setup() {
  add_action( 'add_meta_boxes',                 'gi_add_page_meta_boxes' );
  add_action( 'save_post',                      'gi_save_page_class_meta', 10, 2 );                                        //****************************
}
function gi_add_page_meta_boxes() {
    
    // Check if this is the correct template
    $current_page_template = get_page_template_slug( $post->ID );
    if ( 'page.php' == $current_page_template  || '' == $current_page_template) {
        
    
                            //****************************************************
                                        $unique_id = 'gi-main-desc';
                                        $mb_title = 'Subtitle';
                                        $gi_textdomain = 'human-connection';
                                        $callback_function = 'gi_page_class_meta_box';
                                        $screens = array( 'page' );
                                        $mb_context = 'gi_after_title';
                                        $mb_priority = 'default';
                            //****************************************************
                                            
        add_meta_box($unique_id, esc_html__( $mb_title, $gi_textdomain ), $callback_function, $screens, $mb_context, $mb_priority );
    }
}
function
/* Must match $callback_function */ gi_page_class_meta_box( $post ) { 

                         //****************************************************
                          /*copy*/  $gi_textdomain = 'human-connection';
                          /*copy*/  $unique_id = 'gi-main-desc';
                                    $mb_class_nonce = 'gi_mb_class_nonce';
                                    $mb_label_detail = 'This will be displayed right below the title. This field is recommended, but optional. Text only, please, as this field will not accept HTML.';
                                    $mb_post_class = 'mb_post_class_one';
                         //****************************************************
?>

  <?php wp_nonce_field( basename( __FILE__ ), $mb_class_nonce ); ?>
    <?php _e( "<p>$mb_label_detail</p>", $gi_textdomain ); ?>
    <p>
    <label for="btn-<?php echo $unique_id?>"></label>
    <br />
    <input class="widefat" type="text" name="<?php echo $unique_id?>" id="btn-<?php echo $unique_id?>" value="<?php echo esc_attr( get_post_meta( $post->ID, $mb_post_class, true ) ); ?>" size="30" />
    </p>
  
    <script>jQuery( document ).ready(function() {jQuery('#<?php echo $unique_id ?>').addClass('meta-panel-component').addClass('meta-panel-subtitle');});</script> 
<?php }

function gi_save_page_class_meta( $post_id, $post ) {
    
    // Check if this is the correct template
    $current_page_template = get_page_template_slug( $post->ID );
    if ( 'page.php' == $current_page_template  || '' == $current_page_template) {  
        
                        //****************************************************
                          /*copy*/  $unique_id = 'gi-main-desc';
                          /*copy*/  $mb_class_nonce = 'gi_mb_class_nonce';
                          /*copy*/  $mb_post_class = 'mb_post_class_one';
                        //****************************************************
                        
                        
      if ( !isset( $_POST[$mb_class_nonce] ) || !wp_verify_nonce( $_POST[$mb_class_nonce], basename( __FILE__ ) ) )
        return $post_id; $post_type = get_post_type_object( $post->post_type );
      if ( !current_user_can( $post_type->cap->edit_post, $post_id ) )
        return $post_id; $new_meta_value = ( isset( $_POST[$unique_id] ) ? wp_strip_all_tags( $_POST[$unique_id] ) : '' );
      $meta_key = $mb_post_class; $meta_value = get_post_meta( $post_id, $meta_key, true ); if ( $new_meta_value && '' == $meta_value )
        add_post_meta( $post_id, $meta_key, $new_meta_value, true ); elseif ( $new_meta_value && $new_meta_value != $meta_value )
        update_post_meta( $post_id, $meta_key, $new_meta_value ); elseif ( '' == $new_meta_value && $meta_value )
        delete_post_meta( $post_id, $meta_key, $meta_value );
        
    } // End check if this is the correct template
}


//******************************************************************************
//******************************************************************************
//                            Meta Panel A
//******************************************************************************
//******************************************************************************
function meta_panel_wrapper() { ?>
    <script>jQuery( document ).ready(function() {
        jQuery('.meta-panel-a').wrapAll( "<div class='meta-panel-wrap meta-panel-a-wrap' />").closest('.meta-panel-wrap').prepend('<div class="meta-box-head">Top Section</div>');
        jQuery('.meta-panel-a').wrapAll('<div class="metabox-section" />');
    });</script>
<?php
} 
 add_action( 'admin_print_footer_scripts', 'meta_panel_wrapper');
 
 
 
//******************************************************************************
//                  Custom Meta 2 " Welcome Image Toggle "
//******************************************************************************

                                                // Edit within these boxes only
                                                //****************************
add_action( 'load-post.php',                    'gi_mb_setup_two' );
add_action( 'load-post-new.php',                'gi_mb_setup_two' );
function                                        gi_mb_setup_two() {
  add_action( 'add_meta_boxes',                 'gi_add_meta_boxes_two' );
  add_action( 'save_post',                      'gi_save_class_meta_two', 10, 2 );                                        //****************************
}
function                            
/* Must match 'add_post' action */ gi_add_meta_boxes_two() {

    // Check if this is the correct template
    $current_page_template = get_page_template_slug( $post->ID );
    if ( 'page.php' == $current_page_template  || '' == $current_page_template) {  
        
                        //****************************************************
                                    $unique_id = 'mb_unique_id_two';
                                    $mb_title = 'Welcome Image Toggle';
                                    $gi_textdomain = 'human-connection';
                                    $callback_function = 'mb_class_meta_box_two';
                                    $screens = array( 'page' );
                                    $mb_context = 'gi_after_title';
                                    $mb_priority = 'default';
                        //****************************************************
                                        
        add_meta_box($unique_id, esc_html__( $mb_title, $gi_textdomain ), $callback_function, $screens, $mb_context, $mb_priority );
    
    } // End check if this is the correct template
}
function
/* Must match $callback_function */ mb_class_meta_box_two( $post ) { 

                         //****************************************************
                          /*copy*/  $gi_textdomain = 'human-connection';
                          /*copy*/  $unique_id = 'mb_unique_id_two';
                                    $mb_class_nonce = 'mb_class_nonce_two';
                                    $mb_label_detail = 'Turn the site-wide welcome image off or on.';
                                    $mb_post_class = 'mb_post_class_two';
                         //****************************************************
?>

  <?php wp_nonce_field( basename( __FILE__ ), $mb_class_nonce ); ?>

    <p><?php _e( "<p>$mb_label_detail</p>", $gi_textdomain ); ?></p>
    
    <?php $yes = 'yes-'.$unique_id?>
    <?php $no = 'no-'.$unique_id?>
<p class="btn-switch">					
  <input type="radio"  id="<?php echo $yes ?>" name="<?php echo $unique_id?>" class="btn-switch__radio btn-switch__radio_yes hide"  value="on" />
  <input type="radio"  id="<?php echo $no ?>" name="<?php echo $unique_id?>" class="btn-switch__radio btn-switch__radio_no hide" value="off"  />		
  <label for="<?php echo $yes ?>" class="btn-switch__label btn-switch__label_yes"><span class="btn-switch__txt">On</span></label>								  
  <label for="<?php echo $no ?>" class="btn-switch__label btn-switch__label_no"><span class="btn-switch__txt">Off</span></label>							
</p>


  
    <?php $current_box_state =  get_post_meta( $post->ID, $mb_post_class, true );
    if ($current_box_state === 'on') { ?>
        <script>jQuery('#<?php echo $yes ?>').prop('checked', true);</script>
    <?php } else { ?> 
        <script>jQuery('#<?php echo $no ?>').prop('checked', true);</script>
    <?php  }  ?>

    <script>jQuery( document ).ready(function() {jQuery('#<?php echo $unique_id ?>').addClass('meta-panel-component').addClass('meta-panel-a');});</script> 

<?php }
                        
                        
function                 //***************************************************
/* Must match 'save_post' action */ gi_save_class_meta_two ( $post_id, $post ) {
                          /*copy*/  $unique_id = 'mb_unique_id_two';
                          /*copy*/  $mb_class_nonce = 'mb_class_nonce_two';
                          /*copy*/  $mb_post_class = 'mb_post_class_two';
                        //****************************************************

    // Check if this is the correct template
    $current_page_template = get_page_template_slug( $post->ID );
    if ( 'page.php' == $current_page_template  || '' == $current_page_template) {                     
                            
          if ( !isset( $_POST[$mb_class_nonce] ) || !wp_verify_nonce( $_POST[$mb_class_nonce], basename( __FILE__ ) ) )
            return $post_id; $post_type = get_post_type_object( $post->post_type );
          if ( !current_user_can( $post_type->cap->edit_post, $post_id ) )
            return $post_id; $new_meta_value = ( isset( $_POST[$unique_id] ) ? wp_strip_all_tags( $_POST[$unique_id] ) : '' );
          $meta_key = $mb_post_class; $meta_value = get_post_meta( $post_id, $meta_key, true ); if ( $new_meta_value && '' == $meta_value )
            add_post_meta( $post_id, $meta_key, $new_meta_value, true ); elseif ( $new_meta_value && $new_meta_value != $meta_value )
            update_post_meta( $post_id, $meta_key, $new_meta_value ); elseif ( '' == $new_meta_value && $meta_value )
            delete_post_meta( $post_id, $meta_key, $meta_value );

    } // End check if this is the correct template
}
    
    
    
//******************************************************************************
//       Custom Meta 3 " Welcome Image Use Featured Image Toggle "
//******************************************************************************

                                                // Edit within these boxes only
                                                //****************************
add_action( 'load-post.php',                    'gi_mb_setup_three' );
add_action( 'load-post-new.php',                'gi_mb_setup_three' );
function                                        gi_mb_setup_three() {
  add_action( 'add_meta_boxes',                 'gi_add_meta_boxes_three' );
  add_action( 'save_post',                      'gi_save_class_meta_three', 10, 2 );                                        //****************************
}
function                            
/* Must match 'add_post' action */ gi_add_meta_boxes_three() {

    // Check if this is the correct template
    $current_page_template = get_page_template_slug( $post->ID );
    if ( 'page.php' == $current_page_template  || '' == $current_page_template) {   
    
                        //****************************************************
                                    $unique_id = 'mb_unique_id_three';
                                    $mb_title = 'Use the Featured Image as the Main Image';
                                    $gi_textdomain = 'human-connection';
                                    $callback_function = 'mb_class_meta_box_three';
                                    $screens = array( 'page' );
                                    $mb_context = 'gi_after_title';
                                    $mb_priority = 'default';
                        //****************************************************
                                        
        add_meta_box($unique_id, esc_html__( $mb_title, $gi_textdomain ), $callback_function, $screens, $mb_context, $mb_priority );
    
    } // End check if this is the correct template
}
function
/* Must match $callback_function */ mb_class_meta_box_three( $post ) { 

                         //****************************************************
                          /*copy*/  $gi_textdomain = 'human-connection';
                          /*copy*/  $unique_id = 'mb_unique_id_three';
                                    $mb_class_nonce = 'mb_class_nonce_three';
                                    $mb_label_detail = 'This will be displayed right below the title. This field is recommended, but optional. Text only, please, as this field will not accept HTML.';
                                    $mb_post_class = 'mb_post_class_three';
                         //****************************************************
?>

  <?php wp_nonce_field( basename( __FILE__ ), $mb_class_nonce ); ?>
    
    <p><?php _e( "<p>$mb_label_detail</p>", $gi_textdomain ); ?></p>
    
    <?php $yes = 'yes-'.$unique_id?>
    <?php $no = 'no-'.$unique_id?>
<p class="btn-switch">					
  <input type="radio"  id="<?php echo $yes ?>" name="<?php echo $unique_id?>" class="btn-switch__radio btn-switch__radio_yes hide"  value="on" />
  <input type="radio"  id="<?php echo $no ?>" name="<?php echo $unique_id?>" class="btn-switch__radio btn-switch__radio_no hide" value="off"  />		
  <label for="<?php echo $yes ?>" class="btn-switch__label btn-switch__label_yes"><span class="btn-switch__txt">On</span></label>								  
  <label for="<?php echo $no ?>" class="btn-switch__label btn-switch__label_no"><span class="btn-switch__txt">Off</span></label>							
</p>


  
    <?php $current_box_state =  get_post_meta( $post->ID, $mb_post_class, true );
    if ($current_box_state === 'on') { ?>
        <script>jQuery('#<?php echo $yes ?>').prop('checked', true);</script>
    <?php } else { ?> 
        <script>jQuery('#<?php echo $no ?>').prop('checked', true);</script> 
    <?php  }  ?>

        <script>jQuery( document ).ready(function() {jQuery('#<?php echo $unique_id ?>').addClass('meta-panel-component').addClass('meta-panel-a');});</script> 
        
<?php }
                        
                        
function                 //***************************************************
/* Must match 'save_post' action */ gi_save_class_meta_three ( $post_id, $post ) {
                          /*copy*/  $unique_id = 'mb_unique_id_three';
                          /*copy*/  $mb_class_nonce = 'mb_class_nonce_three';
                          /*copy*/  $mb_post_class = 'mb_post_class_three';
                        //****************************************************
                        
    // Check if this is the correct template
    $current_page_template = get_page_template_slug( $post->ID );
    if ( 'page.php' == $current_page_template  || '' == $current_page_template) {
        
          if ( !isset( $_POST[$mb_class_nonce] ) || !wp_verify_nonce( $_POST[$mb_class_nonce], basename( __FILE__ ) ) )
            return $post_id; $post_type = get_post_type_object( $post->post_type );
          if ( !current_user_can( $post_type->cap->edit_post, $post_id ) )
            return $post_id; $new_meta_value = ( isset( $_POST[$unique_id] ) ? wp_strip_all_tags( $_POST[$unique_id] ) : '' );
          $meta_key = $mb_post_class; $meta_value = get_post_meta( $post_id, $meta_key, true ); if ( $new_meta_value && '' == $meta_value )
            add_post_meta( $post_id, $meta_key, $new_meta_value, true ); elseif ( $new_meta_value && $new_meta_value != $meta_value )
            update_post_meta( $post_id, $meta_key, $new_meta_value ); elseif ( '' == $new_meta_value && $meta_value )
            delete_post_meta( $post_id, $meta_key, $meta_value );
        
    } // End check if this is the correct template
}



//******************************************************************************
//       Custom Meta 4 "Top Section Background Image "
//******************************************************************************
$thisvariable = four;
                                                // Edit within these boxes only
                                                //****************************
add_action( 'load-post.php',                    'gi_mb_setup_four' );
add_action( 'load-post-new.php',                'gi_mb_setup_four' );
function                                        gi_mb_setup_four() {
  add_action( 'add_meta_boxes',                 'gi_add_meta_boxes_four' );
  add_action( 'save_post',                      'gi_save_class_meta_four', 10, 2 );                                                           //****************************
}
function                            
/* Must match 'add_post' action */ gi_add_meta_boxes_four() {

    // Check if this is the correct template    
    $current_page_template = get_page_template_slug( $post->ID );
    if ( 'page.php' == $current_page_template  || '' == $current_page_template) {
    
                        //****************************************************
                                    $unique_id = 'mb_unique_id_four';
                                    $mb_title = 'Top Section Background Image';
                                    $gi_textdomain = 'human-connection';
                                    $callback_function = 'mb_class_meta_box_four';
                                    $screens = array( 'page' );
                                    $mb_context = 'gi_after_title';
                                    $mb_priority = 'default';
                        //****************************************************
                                        
        add_meta_box($unique_id, esc_html__( $mb_title, $gi_textdomain ), $callback_function, $screens, $mb_context, $mb_priority );
    } // End check if this is the correct template
}
function
/* Must match $callback_function */ mb_class_meta_box_four( $post ) { 

                         //****************************************************
                          /*copy*/  $gi_textdomain = 'human-connection';
                          /*copy*/  $unique_id = 'mb_unique_id_four';
                                    $mb_class_nonce = 'mb_class_nonce_four';
                                    $mb_label_detail = 'Top Section Background Image';
                                    $mb_post_class = 'mb_post_class_four';
                         //****************************************************
?>

  <?php wp_nonce_field( basename( __FILE__ ), $mb_class_nonce ); ?>
    
    <p><?php _e( "<p>$mb_label_detail</p>", $gi_textdomain ); ?></p>
    
    <?php $yes = 'yes-'.$unique_id?>
    <?php $no = 'no-'.$unique_id?>
<p class="btn-switch">					
  <input type="radio"  id="<?php echo $yes ?>" name="<?php echo $unique_id?>" class="btn-switch__radio btn-switch__radio_yes hide"  value="on" />
  <input type="radio"  id="<?php echo $no ?>" name="<?php echo $unique_id?>" class="btn-switch__radio btn-switch__radio_no hide" value="off"  />		
  <label for="<?php echo $yes ?>" class="btn-switch__label btn-switch__label_yes"><span class="btn-switch__txt">On</span></label>								  
  <label for="<?php echo $no ?>" class="btn-switch__label btn-switch__label_no"><span class="btn-switch__txt">Off</span></label>							
</p>


  
    <?php $current_box_state =  get_post_meta( $post->ID, $mb_post_class, true );
    if ($current_box_state === 'on') { ?>
        <script>jQuery('#<?php echo $yes ?>').prop('checked', true);</script>
    <?php } else { ?> 
        <script>jQuery('#<?php echo $no ?>').prop('checked', true);</script>
    <?php  }  ?>

        <script>jQuery( document ).ready(function() {jQuery('#<?php echo $unique_id ?>').addClass('meta-panel-component').addClass('meta-panel-a');});</script> 
        
<?php }
                        
                        
function                 //***************************************************
/* Must match 'save_post' action */ gi_save_class_meta_four ( $post_id, $post ) {
                          /*copy*/  $unique_id = 'mb_unique_id_four';
                          /*copy*/  $mb_class_nonce = 'mb_class_nonce_four';
                          /*copy*/  $mb_post_class = 'mb_post_class_four';
                        //****************************************************

    // Check if this is the correct template                        
    $current_page_template = get_page_template_slug( $post->ID );
    if ( 'page.php' == $current_page_template  || '' == $current_page_template) {
        
          if ( !isset( $_POST[$mb_class_nonce] ) || !wp_verify_nonce( $_POST[$mb_class_nonce], basename( __FILE__ ) ) )
            return $post_id; $post_type = get_post_type_object( $post->post_type );
          if ( !current_user_can( $post_type->cap->edit_post, $post_id ) )
            return $post_id; $new_meta_value = ( isset( $_POST[$unique_id] ) ? wp_strip_all_tags( $_POST[$unique_id] ) : '' );
          $meta_key = $mb_post_class; $meta_value = get_post_meta( $post_id, $meta_key, true ); if ( $new_meta_value && '' == $meta_value )
            add_post_meta( $post_id, $meta_key, $new_meta_value, true ); elseif ( $new_meta_value && $new_meta_value != $meta_value )
            update_post_meta( $post_id, $meta_key, $new_meta_value ); elseif ( '' == $new_meta_value && $meta_value )
            delete_post_meta( $post_id, $meta_key, $meta_value );
    
    } // End check if this is the correct template
}


//******************************************************************************
//   Custom Meta 10 Toggle on/off the Headline/Title 
//******************************************************************************
add_action( 'add_meta_boxes', 'mb_tt_add' );
function mb_tt_add() {

                                            // Edit within these boxes only
                                            //****************************
                                            $unique_id = 'meta-box-tt';                         
                                            $screens = array( 'post', 'page');
                                            $mb_context = 'gi_after_title';
                                            //****************************
    add_meta_box(   $unique_id, 
                    'Hide the Title', 
                    'mb_title_toggle', 
                    $screens, 
                     $mb_context, 
                    'default' );
}
function mb_title_toggle( $post ) {
                                    
                                    //****************************
                                    /*copy*/    $unique_id = 'meta-box-tt';                         
                                    //****************************
    $titletoggle = 'no' ;
    wp_nonce_field( 'my_meta_box_nonce', 'meta_box_nonce' );
    ?>
    <div id="<?php echo $unique_id ?>">
        <label>Check to hide the title</label>
        <?php $field_id_value = get_post_meta($post->ID, 'mb_title_toggle', true);
        
        if($field_id_value == "yes") {
            $field_id_checked = 'checked="checked"';
            $titletoggle = 'yes' ;
            }?>
        <input type="checkbox" name="mb_title_toggle" value="yes" <?php echo $field_id_checked; ?> />
    </div>
    
    <script>jQuery( document ).ready(function() {jQuery('#<?php echo $unique_id ?>').addClass('meta-panel-component').addClass('meta-panel-a');});</script>
    <?php
}
add_action( 'save_post', 'mb_tt_save' );
function mb_tt_save( $post_id ) {
    // Bail if we're doing an auto save
    if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
    // if our nonce isn't there, or we can't verify it, bail
    if( !isset( $_POST['meta_box_nonce'] ) || !wp_verify_nonce( $_POST['meta_box_nonce'], 'my_meta_box_nonce' ) ) return;
    // if our current user can't edit this post, bail
    if( !current_user_can( 'edit_post', $post_id ) ) return;
    // now we can actually save the data
    $allowed = array( 
        'a' => array( // on allow a tags
            'href' => array() // and those anchords can only have href attribute
        )
    );
        update_post_meta( $post_id, 'mb_title_toggle', wp_kses( $_POST['mb_title_toggle'], $allowed ) );
}



//******************************************************************************
//       Custom Meta 7 "Title Background"
//******************************************************************************

                                                // Edit within these boxes only
                                                //****************************
add_action( 'load-post.php',                    'gi_mb_setup_seven' );
add_action( 'load-post-new.php',                'gi_mb_setup_seven' );
function                                        gi_mb_setup_seven() {
  add_action( 'add_meta_boxes',                 'gi_add_meta_boxes_seven' );
  add_action( 'save_post',                      'gi_save_class_meta_seven', 10, 2 );                                        //****************************
}
function                            
/* Must match 'add_post' action */ gi_add_meta_boxes_seven() {

    // Check if this is the correct template
    $current_page_template = get_page_template_slug( $post->ID );
    if ( 'page.php' == $current_page_template  || '' == $current_page_template) {
    
                        //****************************************************
                                    $unique_id = 'mb_unique_id_seven';
                                    $mb_title = 'Title Background';
                                    $gi_textdomain = 'human-connection';
                                    $callback_function = 'mb_class_meta_box_seven';
                                    $screens = array( 'page' );
                                    $mb_context = 'gi_after_title';
                                    $mb_priority = 'default';
                        //****************************************************
                                        
        add_meta_box($unique_id, esc_html__( $mb_title, $gi_textdomain ), $callback_function, $screens, $mb_context, $mb_priority );
    
    } // End check if this is the correct template
}
function
/* Must match $callback_function */ mb_class_meta_box_seven( $post ) { 

                         //****************************************************
                          /*copy*/  $gi_textdomain = 'human-connection';
                          /*copy*/  $unique_id = 'mb_unique_id_seven';
                                    $mb_class_nonce = 'mb_class_nonce_seven';
                                    $mb_label_detail = 'This will be most effective when using an image as the top section background.';
                                    $mb_post_class = 'mb_post_class_seven';
                         //****************************************************
?>

  <?php wp_nonce_field( basename( __FILE__ ), $mb_class_nonce ); ?>
    
    <p><?php _e( "<p>$mb_label_detail</p>", $gi_textdomain ); ?></p>
    
    <?php $yes = 'yes-'.$unique_id?>
    <?php $no = 'no-'.$unique_id?>
<p class="btn-switch">					
  <input type="radio"  id="<?php echo $yes ?>" name="<?php echo $unique_id?>" class="btn-switch__radio btn-switch__radio_yes hide"  value="on" />
  <input type="radio"  id="<?php echo $no ?>" name="<?php echo $unique_id?>" class="btn-switch__radio btn-switch__radio_no hide" value="off"  />		
  <label for="<?php echo $yes ?>" class="btn-switch__label btn-switch__label_yes"><span class="btn-switch__txt">On</span></label>								  
  <label for="<?php echo $no ?>" class="btn-switch__label btn-switch__label_no"><span class="btn-switch__txt">Off</span></label>							
</p>


  
    <?php $current_box_state =  get_post_meta( $post->ID, $mb_post_class, true );
    if ($current_box_state === 'on') { ?>
        <script>jQuery('#<?php echo $yes ?>').prop('checked', true);</script>
    <?php } else { ?> 
        <script>jQuery('#<?php echo $no ?>').prop('checked', true);</script>
    <?php  }  ?>

        <script>jQuery( document ).ready(function() {jQuery('#<?php echo $unique_id ?>').addClass('meta-panel-component').addClass('meta-panel-a');});</script> 
        
<?php }
                        
                        
function                 //***************************************************
/* Must match 'save_post' action */ gi_save_class_meta_seven ( $post_id, $post ) {
                          /*copy*/  $unique_id = 'mb_unique_id_seven';
                          /*copy*/  $mb_class_nonce = 'mb_class_nonce_seven';
                          /*copy*/  $mb_post_class = 'mb_post_class_seven';
                        //****************************************************
                        
    // Check if this is the correct template
    $current_page_template = get_page_template_slug( $post->ID );
    if ( 'page.php' == $current_page_template  || '' == $current_page_template) {
        
          if ( !isset( $_POST[$mb_class_nonce] ) || !wp_verify_nonce( $_POST[$mb_class_nonce], basename( __FILE__ ) ) )
            return $post_id; $post_type = get_post_type_object( $post->post_type );
          if ( !current_user_can( $post_type->cap->edit_post, $post_id ) )
            return $post_id; $new_meta_value = ( isset( $_POST[$unique_id] ) ? wp_strip_all_tags( $_POST[$unique_id] ) : '' );
          $meta_key = $mb_post_class; $meta_value = get_post_meta( $post_id, $meta_key, true ); if ( $new_meta_value && '' == $meta_value )
            add_post_meta( $post_id, $meta_key, $new_meta_value, true ); elseif ( $new_meta_value && $new_meta_value != $meta_value )
            update_post_meta( $post_id, $meta_key, $new_meta_value ); elseif ( '' == $new_meta_value && $meta_value )
            delete_post_meta( $post_id, $meta_key, $meta_value );
    
    } // End check if this is the correct template
}




//******************************************************************************
//       Custom Meta 8 Main Section Text Color
//******************************************************************************

                                                // Edit within these boxes only
                                                //****************************
add_action( 'load-post.php',                    'gi_mb_setup_eight' );
add_action( 'load-post-new.php',                'gi_mb_setup_eight' );
function                                        gi_mb_setup_eight() {
  add_action( 'add_meta_boxes',                 'gi_add_meta_boxes_eight' );
  add_action( 'save_post',                      'gi_save_class_meta_eight', 10, 2 );                                        //****************************
}
function                            
/* Must match 'add_post' action */ gi_add_meta_boxes_eight() {

    // Check if this is the correct template
    $current_page_template = get_page_template_slug( $post->ID );
    if ( 'page.php' == $current_page_template  || '' == $current_page_template) {
    
                        //****************************************************
                                    $unique_id = 'mb_unique_id_eight';
                                    $mb_title = 'Page Title Color';
                                    $gi_textdomain = 'human-connection';
                                    $callback_function = 'mb_class_meta_box_eight';
                                    $screens = array( 'page' );
                                    $mb_context = 'gi_after_title';
                                    $mb_priority = 'default';
                        //****************************************************
                                        
        add_meta_box($unique_id, esc_html__( $mb_title, $gi_textdomain ), $callback_function, $screens, $mb_context, $mb_priority );
        
    } // End check if this is the correct template
}

function
/* Must match $callback_function */ mb_class_meta_box_eight( $post ) { 

                         //****************************************************
                          /*copy*/  $gi_textdomain = 'human-connection';
                          /*copy*/  $unique_id = 'mb_unique_id_eight';
                                    $mb_class_nonce = 'mb_class_nonce_eight';
                                    $mb_label_detail = 'Change the page title color.';
                                    $mb_post_class = 'mb_post_class_eight';
                         //****************************************************
        ?>
        
          <?php wp_nonce_field( basename( __FILE__ ), $mb_class_nonce ); ?>
            
            <p><?php _e( "<p>$mb_label_detail</p>", $gi_textdomain ); ?></p>
            
            <?php $yes = 'yes-'.$unique_id?>
            <?php $no = 'no-'.$unique_id?>
        <div class="color-picker-wrap">	
        <?php $current_box_state =  get_post_meta( $post->ID, $mb_post_class, true ); ?>
          <input type="color"  id="<?php echo $yes ?>" name="<?php echo $unique_id?>" class="color-field "  value="<?php 
          
          if ( $current_box_state === '' ) {
              
                echo 'giThemeColorPalette[1]';
              
          } else {
              
               echo $current_box_state;
          }
          
         ?>" />
          
          <?php print_r($themePaletteDefault); ?>
        								
        </div>

 
        <script> // Setting up Iris Color Picker: Replace Clear button with the Restore button, set up palett with site-wide palett and other settings (if needed)
            jQuery( window ).load(function() {
                
                // set RGB to Hex function and color-holder variable for later use.
                function rgb2hex(rgb) {
                    
                     if (  rgb.search("rgb") == -1 ) {
                         
                          return rgb;
                          
                     } else {
                         
                          rgb = rgb.match(/^rgba?\((\d+),\s*(\d+),\s*(\d+)(?:,\s*(\d+))?\)$/);
                          
                          function hex(x) {
                              
                               return ("0" + parseInt(x).toString(16)).slice(-2);
                               
                          }
                          
                          return "#" + hex(rgb[1]) + hex(rgb[2]) + hex(rgb[3]); 
                     }
                }
    
                var currentcolorthisId;
                                            
                waitForElement('#<?php echo $yes ?>', function() {
                    jQuery('#<?php echo $yes ?>')
                        .iris({
                            hide: true,
                            palettes: 
                            [giThemeColorPalette[0], 
                            giThemeColorPalette[1], 
                            giThemeColorPalette[2], 
                            giThemeColorPalette[3], 
                            giThemeColorPalette[4], 
                            giThemeColorPalette[5], 
                            giThemeColorPalette[6]]
                        })

                    ;
                    
                    
                    // Store the color this setting begins with at page-load   
                    currentcolorthisId = jQuery('#<?php echo $unique_id ?>').find( '.wp-color-result' ).css('background-color');

    
                    currentcolorthisId = rgb2hex(currentcolorthisId);
                   
                   
            
                }); //END waiting for element '# echo $yes ?>'
    
    
                // Wait for the Iris "Clear" button to appear and replace it with a "Restore" button. Doing this eliminates the functions tied to the Clear button
                waitForElement('#<?php echo $unique_id ?> input.button.button-small.wp-picker-clear', 
                
                    function() {
                        
                            jQuery('#<?php echo $unique_id ?> input.button.button-small.wp-picker-clear').replaceWith('<button type="button" id="<?php echo$unique_id ?>-undo-btn" class="iris-restore-btn iris-undo-btn">undo</button><button type="button" id="<?php echo$unique_id ?>-restore-btn" class="iris-restore-btn">Restore</button>');
                            
                            
                            waitForElement('#<?php echo $unique_id ?>-undo-btn', 
                            
                            function() {
                                
                                    jQuery('button#<?php echo $unique_id ?>-undo-btn').on('click', 
                                    
                                        function() {
    
                                            // Upon clicking the undo button, return the three color points to the starting color held in currentcolorthisId
                                            jQuery('#<?php echo $unique_id ?> ').find( '.color-field' ).val(currentcolorthisId).closest('.meta-panel-component').find('.iris-slider.iris-strip').css('background', currentcolorthisId).closest('.meta-panel-component').find( '.wp-color-result' ).css('background', currentcolorthisId);
                                        }
                                    );
                            });
                            
                             waitForElement('#<?php echo $unique_id ?>-restore-btn', 
                            
                            function() {
                                
                                    jQuery('button#<?php echo $unique_id ?>-restore-btn').on('click', 
                                    
                                        function() {
    
                                            // Upon clicking the restore button, return the three color points to the starting color held in giThemeColorPalette[1]
                                            jQuery('#<?php echo $unique_id ?> ').find( '.color-field' ).val(giThemeColorPalette[1]).closest('.meta-panel-component').find('.iris-slider.iris-strip').css('background', giThemeColorPalette[1]).closest('.meta-panel-component').find( '.wp-color-result' ).css('background', giThemeColorPalette[1]);
                                        }
                                    );
                            });
                            
                    }
                );
            
                waitForElement('.button.wp-color-result span.wp-color-result-text', 
                        function() {
                            
                            // Change the text of the "Select Color" button to "Close" when Iris is open
                            jQuery('.button.wp-color-result span.wp-color-result-text').text('');
                    }
                );

          
        }); // END 'jQuery( window ).load(function()'

        </script>
        
        
        <script>jQuery( document ).ready(function() {jQuery('#<?php echo $unique_id ?>').addClass('meta-panel-component').addClass('meta-panel-a');});</script> 
        
<?php }
                        
                        
function                 //***************************************************
/* Must match 'save_post' action */ gi_save_class_meta_eight ( $post_id, $post ) {
                          /*copy*/  $unique_id = 'mb_unique_id_eight';
                          /*copy*/  $mb_class_nonce = 'mb_class_nonce_eight';
                          /*copy*/  $mb_post_class = 'mb_post_class_eight';
                        //****************************************************
                        
    // Check if this is the correct template
    $current_page_template = get_page_template_slug( $post->ID );
    if ( 'page.php' == $current_page_template  || '' == $current_page_template) { 
        
          if ( !isset( $_POST[$mb_class_nonce] ) || !wp_verify_nonce( $_POST[$mb_class_nonce], basename( __FILE__ ) ) )
            return $post_id; $post_type = get_post_type_object( $post->post_type );
          if ( !current_user_can( $post_type->cap->edit_post, $post_id ) )
            return $post_id; $new_meta_value = ( isset( $_POST[$unique_id] ) ? wp_strip_all_tags( $_POST[$unique_id] ) : '' );
          $meta_key = $mb_post_class; $meta_value = get_post_meta( $post_id, $meta_key, true ); if ( $new_meta_value && '' == $meta_value )
            add_post_meta( $post_id, $meta_key, $new_meta_value, true ); elseif ( $new_meta_value && $new_meta_value != $meta_value )
            update_post_meta( $post_id, $meta_key, $new_meta_value ); elseif ( '' == $new_meta_value && $meta_value )
            delete_post_meta( $post_id, $meta_key, $meta_value );
            
    } // End check if this is the correct template
}





//******************************************************************************
//******************************************************************************
//                            Meta Panel B
//******************************************************************************
//******************************************************************************
function meta_panel_wrapper_b() { ?>
    <script>jQuery( document ).ready(function() {
        jQuery('.meta-panel-b').wrapAll( "<div class='meta-panel-wrap meta-panel-b-wrap' />").closest('.meta-panel-wrap').prepend('<div class="meta-box-head">Main Section</div>');
        jQuery('.meta-panel-b').wrapAll('<div class="metabox-section" />');
    });</script>
<?php
} 
 add_action( 'admin_print_footer_scripts', 'meta_panel_wrapper_b');
 
 
 
 
//******************************************************************************
//       Custom Meta 5 Main Section Background "Frosted Glass"
//******************************************************************************

                                                // Edit within these boxes only
                                                //****************************
add_action( 'load-post.php',                    'gi_mb_setup_five' );
add_action( 'load-post-new.php',                'gi_mb_setup_five' );
function                                        gi_mb_setup_five() {
  add_action( 'add_meta_boxes',                 'gi_add_meta_boxes_five' );
  add_action( 'save_post',                      'gi_save_class_meta_five', 10, 2 );                                                           //****************************
}
function                            
/* Must match 'add_post' action */ gi_add_meta_boxes_five() {
    
    // Check if this is the correct template
    $current_page_template = get_page_template_slug( $post->ID );
    if ( 'page.php' == $current_page_template  || '' == $current_page_template) { 
    
                        //****************************************************
                                    $unique_id = 'mb_unique_id_five';
                                    $mb_title = 'Background: Frosted Glass';
                                    $gi_textdomain = 'human-connection';
                                    $callback_function = 'mb_class_meta_box_five';
                                    $screens = array( 'page' );
                                    $mb_context = 'gi_after_title';
                                    $mb_priority = 'default';
                        //****************************************************
                                        
    add_meta_box($unique_id, esc_html__( $mb_title, $gi_textdomain ), $callback_function, $screens, $mb_context, $mb_priority );

    } // End check if this is the correct template
}
function
/* Must match $callback_function */ mb_class_meta_box_five( $post ) { 

                         //****************************************************
                          /*copy*/  $gi_textdomain = 'human-connection';
                          /*copy*/  $unique_id = 'mb_unique_id_five';
                                    $mb_class_nonce = 'mb_class_nonce_five';
                                    $mb_label_detail = 'Background: Frosted Glass';
                                    $mb_post_class = 'mb_post_class_five';
                         //****************************************************
?>

  <?php wp_nonce_field( basename( __FILE__ ), $mb_class_nonce ); ?>
    
    <p><?php _e( "<p>$mb_label_detail</p>", $gi_textdomain ); ?></p>
    
    <?php $yes = 'yes-'.$unique_id?>
    <?php $no = 'no-'.$unique_id?>
<p class="btn-switch">					
  <input type="radio"  id="<?php echo $yes ?>" name="<?php echo $unique_id?>" class="btn-switch__radio btn-switch__radio_yes hide"  value="on" />
  <input type="radio"  id="<?php echo $no ?>" name="<?php echo $unique_id?>" class="btn-switch__radio btn-switch__radio_no hide" value="off"  />		
  <label for="<?php echo $yes ?>" class="btn-switch__label btn-switch__label_yes"><span class="btn-switch__txt">On</span></label>								  
  <label for="<?php echo $no ?>" class="btn-switch__label btn-switch__label_no"><span class="btn-switch__txt">Off</span></label>							
</p>


  
    <?php $current_box_state =  get_post_meta( $post->ID, $mb_post_class, true );
    if ($current_box_state === 'on') { ?>
        <script>jQuery('#<?php echo $yes ?>').prop('checked', true);</script>
    <?php } else { ?> 
        <script>jQuery('#<?php echo $no ?>').prop('checked', true);</script>
    <?php  }  ?>

        <script>jQuery( document ).ready(function() {jQuery('#<?php echo $unique_id ?>').addClass('meta-panel-component').addClass('meta-panel-b');});</script> 
        
<?php }
                        
                        
function                 //***************************************************
/* Must match 'save_post' action */ gi_save_class_meta_five ( $post_id, $post ) {
                          /*copy*/  $unique_id = 'mb_unique_id_five';
                          /*copy*/  $mb_class_nonce = 'mb_class_nonce_five';
                          /*copy*/  $mb_post_class = 'mb_post_class_five';
                        //****************************************************
                        
    // Check if this is the correct template
    $current_page_template = get_page_template_slug( $post->ID );
    if ( 'page.php' == $current_page_template  || '' == $current_page_template) { 
        
          if ( !isset( $_POST[$mb_class_nonce] ) || !wp_verify_nonce( $_POST[$mb_class_nonce], basename( __FILE__ ) ) )
            return $post_id; $post_type = get_post_type_object( $post->post_type );
          if ( !current_user_can( $post_type->cap->edit_post, $post_id ) )
            return $post_id; $new_meta_value = ( isset( $_POST[$unique_id] ) ? wp_strip_all_tags( $_POST[$unique_id] ) : '' );
          $meta_key = $mb_post_class; $meta_value = get_post_meta( $post_id, $meta_key, true ); if ( $new_meta_value && '' == $meta_value )
            add_post_meta( $post_id, $meta_key, $new_meta_value, true ); elseif ( $new_meta_value && $new_meta_value != $meta_value )
            update_post_meta( $post_id, $meta_key, $new_meta_value ); elseif ( '' == $new_meta_value && $meta_value )
            delete_post_meta( $post_id, $meta_key, $meta_value );
    
    } // End check if this is the correct template
}




//******************************************************************************
//       Custom Meta 6 Main Section Background "Post Style Inset"
//******************************************************************************

                                                // Edit within these boxes only
                                                //****************************
add_action( 'load-post.php',                    'gi_mb_setup_six' );
add_action( 'load-post-new.php',                'gi_mb_setup_six' );
function                                        gi_mb_setup_six() {
  add_action( 'add_meta_boxes',                 'gi_add_meta_boxes_six' );
  add_action( 'save_post',                      'gi_save_class_meta_six', 10, 2 );                                                            //****************************
}
function                            
/* Must match 'add_post' action */ gi_add_meta_boxes_six() {
    
    // Check if this is the correct template
    $current_page_template = get_page_template_slug( $post->ID );
    if ( 'page.php' == $current_page_template  || '' == $current_page_template) { 
    
                        //****************************************************
                                    $unique_id = 'mb_unique_id_six';
                                    $mb_title = 'Background: Post Style';
                                    $gi_textdomain = 'human-connection';
                                    $callback_function = 'mb_class_meta_box_six';
                                    $screens = array( 'page' );
                                    $mb_context = 'gi_after_title';
                                    $mb_priority = 'default';
                        //****************************************************
                                        
        add_meta_box($unique_id, esc_html__( $mb_title, $gi_textdomain ), $callback_function, $screens, $mb_context, $mb_priority );
        
    } // End check if this is the correct template
}
function
/* Must match $callback_function */ mb_class_meta_box_six( $post ) { 

                         //****************************************************
                          /*copy*/  $gi_textdomain = 'human-connection';
                          /*copy*/  $unique_id = 'mb_unique_id_six';
                                    $mb_class_nonce = 'mb_class_nonce_six';
                                    $mb_label_detail = 'Main Section Background "Post Style Inset"';
                                    $mb_post_class = 'mb_post_class_six';
                         //****************************************************
?>

  <?php wp_nonce_field( basename( __FILE__ ), $mb_class_nonce ); ?>
    
    <p><?php _e( "<p>$mb_label_detail</p>", $gi_textdomain ); ?></p>
    
    <?php $yes = 'yes-'.$unique_id?>
    <?php $no = 'no-'.$unique_id?>
<p class="btn-switch">					
  <input type="radio"  id="<?php echo $yes ?>" name="<?php echo $unique_id?>" class="btn-switch__radio btn-switch__radio_yes hide"  value="on" />
  <input type="radio"  id="<?php echo $no ?>" name="<?php echo $unique_id?>" class="btn-switch__radio btn-switch__radio_no hide" value="off"  />	
  
  <label for="<?php echo $yes ?>" class="btn-switch__label btn-switch__label_yes"><span class="btn-switch__txt">On</span></label>								  
  <label for="<?php echo $no ?>" class="btn-switch__label btn-switch__label_no"><span class="btn-switch__txt">Off</span></label>							
</p>


  
    <?php $current_box_state =  get_post_meta( $post->ID, $mb_post_class, true );
    if ($current_box_state === 'on') { ?>
        <script>jQuery('#<?php echo $yes ?>').prop('checked', true);</script>
    <?php } else { ?> 
        <script>jQuery('#<?php echo $no ?>').prop('checked', true);</script>
    <?php  }  ?>

        <script>jQuery( document ).ready(function() {jQuery('#<?php echo $unique_id ?>').addClass('meta-panel-component').addClass('meta-panel-b');});</script> 
        
<?php }
                        
                        
function                 //***************************************************
/* Must match 'save_post' action */ gi_save_class_meta_six ( $post_id, $post ) {
                          /*copy*/  $unique_id = 'mb_unique_id_six';
                          /*copy*/  $mb_class_nonce = 'mb_class_nonce_six';
                          /*copy*/  $mb_post_class = 'mb_post_class_six';
                        //****************************************************
                        
    // Check if this is the correct template
    $current_page_template = get_page_template_slug( $post->ID );
    if ( 'page.php' == $current_page_template  || '' == $current_page_template) { 
    
                            
  if ( !isset( $_POST[$mb_class_nonce] ) || !wp_verify_nonce( $_POST[$mb_class_nonce], basename( __FILE__ ) ) )
    return $post_id; $post_type = get_post_type_object( $post->post_type );
  if ( !current_user_can( $post_type->cap->edit_post, $post_id ) )
    return $post_id; $new_meta_value = ( isset( $_POST[$unique_id] ) ? wp_strip_all_tags( $_POST[$unique_id] ) : '' );
  $meta_key = $mb_post_class; $meta_value = get_post_meta( $post_id, $meta_key, true ); if ( $new_meta_value && '' == $meta_value )
    add_post_meta( $post_id, $meta_key, $new_meta_value, true ); elseif ( $new_meta_value && $new_meta_value != $meta_value )
    update_post_meta( $post_id, $meta_key, $new_meta_value ); elseif ( '' == $new_meta_value && $meta_value )
    delete_post_meta( $post_id, $meta_key, $meta_value );
        
    } // End check if this is the correct template
}


//******************************************************************************
//       Custom Meta 9 Main Section Text Color
//******************************************************************************

                                                // Edit within these boxes only
                                                //****************************
add_action( 'load-post.php',                    'gi_mb_setup_nine' );
add_action( 'load-post-new.php',                'gi_mb_setup_nine' );
function                                        gi_mb_setup_nine() {
  add_action( 'add_meta_boxes',                 'gi_add_meta_boxes_nine' );
  add_action( 'save_post',                      'gi_save_class_meta_nine', 10, 2 );                                                           //****************************
}
function                            
/* Must match 'add_post' action */ gi_add_meta_boxes_nine() {

    // Check if this is the correct template
    $current_page_template = get_page_template_slug( $post->ID );
    if ( 'page.php' == $current_page_template  || '' == $current_page_template) { 
    
                        //****************************************************
                                    $unique_id = 'mb_unique_id_nine';
                                    $mb_title = 'Main Section Text Color';
                                    $gi_textdomain = 'human-connection';
                                    $callback_function = 'mb_class_meta_box_nine';
                                    $screens = array( 'page' );
                                    $mb_context = 'gi_after_title';
                                    $mb_priority = 'default';
                        //****************************************************
                                        
        add_meta_box($unique_id, esc_html__( $mb_title, $gi_textdomain ), $callback_function, $screens, $mb_context, $mb_priority );
    } // End check if this is the correct template
}
function
/* Must match $callback_function */ mb_class_meta_box_nine( $post ) { 

                         //****************************************************
                          /*copy*/  $gi_textdomain = 'human-connection';
                          /*copy*/  $unique_id = 'mb_unique_id_nine';
                                    $mb_class_nonce = 'mb_class_nonce_nine';
                                    $mb_label_detail = 'Main Section Text Color.';
                                    $mb_post_class = 'mb_post_class_nine';
                         //****************************************************
?>

  <?php wp_nonce_field( basename( __FILE__ ), $mb_class_nonce ); ?>
    
    <p><?php _e( "<p>$mb_label_detail</p>", $gi_textdomain ); ?></p>
    
    <?php $yes = 'yes-'.$unique_id?>
    <?php $no = 'no-'.$unique_id?>
    
<div class="color-picker-wrap">
    
    <?php $current_box_state =  get_post_meta( $post->ID, $mb_post_class, true );?>
  <input type="color"  id="<?php echo $yes ?>" name="<?php echo $unique_id?>" class="color-field "  value="<?php echo $current_box_state ?>" />
  
								
</div>


  
    <?php $current_box_state =  get_post_meta( $post->ID, $mb_post_class, true );
    if ($current_box_state === 'on') { ?>
        <script>jQuery('#<?php echo $yes ?>').prop('checked', true);</script>
    <?php } else { ?> 
        <script>jQuery('#<?php echo $no ?>').prop('checked', true);</script>
    <?php  }  ?>

        <script>jQuery( document ).ready(function() {jQuery('#<?php echo $unique_id ?>').addClass('meta-panel-component').addClass('meta-panel-b');});</script> 
        
        <script> // Setting up Iris Color Picker: Replace Clear button with the Restore button, set up palett with site-wide palett and other settings (if needed)
            jQuery( window ).load(function() {
            
            // set RGB to Hex function and color-holder variable for later use.
            function rgb2hex(rgb) {
                 if (  rgb.search("rgb") == -1 ) {
                      return rgb;
                 } else {
                      rgb = rgb.match(/^rgba?\((\d+),\s*(\d+),\s*(\d+)(?:,\s*(\d+))?\)$/);
                      function hex(x) {
                           return ("0" + parseInt(x).toString(16)).slice(-2);
                      }
                      return "#" + hex(rgb[1]) + hex(rgb[2]) + hex(rgb[3]); 
                 }
            }

            var currentcolorthisId;
                                        
                                        
            waitForElement('#<?php echo $yes ?>', function() {
                jQuery('#<?php echo $yes ?>')
                    .iris({
                        hide: true,
                        palettes: 
                        [giThemeColorPalette[0], 
                        giThemeColorPalette[1], 
                        giThemeColorPalette[2], 
                        giThemeColorPalette[3], 
                        giThemeColorPalette[4], 
                        giThemeColorPalette[5], 
                        giThemeColorPalette[6]]
                    })
                    .prepend('<button id="<?php echo $unique_id ?>-restore-btn" class="iris-restore-btn">Restore</button>')
                ;
                
                
                // Store the color this setting begins with at page-load   
                currentcolorthisId = jQuery('#<?php echo $unique_id ?>').find( '.wp-color-result' ).css('background-color');
                
                console.log('currentcolorthisId 1', currentcolorthisId);

                

                currentcolorthisId = rgb2hex(currentcolorthisId);
                
               console.log('#<?php echo $yes ?>', 'currentcolorthisId 2', currentcolorthisId);
               
               
        
            }); //END waiting for element '# echo $yes ?>'


                // Wait for the Iris "Clear" button to appear and replace it with a "Restore" button. Doing this eliminates the functions tied to the Clear button
                waitForElement('#<?php echo $unique_id ?> input.button.button-small.wp-picker-clear', 
                
                    function() {
                        
                            jQuery('#<?php echo $unique_id ?> input.button.button-small.wp-picker-clear').replaceWith('<button type="button" id="<?php echo$unique_id ?>-undo-btn" class="iris-restore-btn iris-undo-btn">undo</button><button type="button" id="<?php echo$unique_id ?>-restore-btn" class="iris-restore-btn">Restore</button>');
                            
                            
                            waitForElement('#<?php echo $unique_id ?>-undo-btn', 
                            
                            function() {
                                
                                    jQuery('button#<?php echo $unique_id ?>-undo-btn').on('click', 
                                    
                                        function() {
    
                                            // Upon clicking the undo button, return the three color points to the starting color held in currentcolorthisId
                                            jQuery('#<?php echo $unique_id ?> ').find( '.color-field' ).val(currentcolorthisId).closest('.meta-panel-component').find('.iris-slider.iris-strip').css('background', currentcolorthisId).closest('.meta-panel-component').find( '.wp-color-result' ).css('background', currentcolorthisId);
                                        }
                                    );
                            });
                            
                             waitForElement('#<?php echo $unique_id ?>-restore-btn', 
                            
                            function() {
                                
                                    jQuery('button#<?php echo $unique_id ?>-restore-btn').on('click', 
                                    
                                        function() {
    
                                            // Upon clicking the restore button, return the three color points to the starting color held in giThemeColorPalette[0]
                                            jQuery('#<?php echo $unique_id ?> ').find( '.color-field' ).val(giThemeColorPalette[0]).closest('.meta-panel-component').find('.iris-slider.iris-strip').css('background', giThemeColorPalette[0]).closest('.meta-panel-component').find( '.wp-color-result' ).css('background', giThemeColorPalette[0]);
                                        }
                                    );
                            });
                            
                    }
                );
    
        
            waitForElement('.button.wp-color-result span.wp-color-result-text', 
                    function() {
                        
                        // Change the text of the "Select Color" button to "Close" when Iris is open
                        jQuery('.button.wp-color-result span.wp-color-result-text').text('');
                }
            );

          
        }); // END 'jQuery( window ).load(function()'

        </script>
<?php }
                        
                        
function                 //***************************************************
/* Must match 'save_post' action */ gi_save_class_meta_nine ( $post_id, $post ) {
                          /*copy*/  $unique_id = 'mb_unique_id_nine';
                          /*copy*/  $mb_class_nonce = 'mb_class_nonce_nine';
                          /*copy*/  $mb_post_class = 'mb_post_class_nine';
                        //****************************************************
                        
    // Check if this is the correct template
    $current_page_template = get_page_template_slug( $post->ID );
    if ( 'page.php' == $current_page_template || '' == $current_page_template) { 
        
  if ( !isset( $_POST[$mb_class_nonce] ) || !wp_verify_nonce( $_POST[$mb_class_nonce], basename( __FILE__ ) ) )
    return $post_id; $post_type = get_post_type_object( $post->post_type );
  if ( !current_user_can( $post_type->cap->edit_post, $post_id ) )
    return $post_id; $new_meta_value = ( isset( $_POST[$unique_id] ) ? wp_strip_all_tags( $_POST[$unique_id] ) : '' );
  $meta_key = $mb_post_class; $meta_value = get_post_meta( $post_id, $meta_key, true ); if ( $new_meta_value && '' == $meta_value )
    add_post_meta( $post_id, $meta_key, $new_meta_value, true ); elseif ( $new_meta_value && $new_meta_value != $meta_value )
    update_post_meta( $post_id, $meta_key, $new_meta_value ); elseif ( '' == $new_meta_value && $meta_value )
    delete_post_meta( $post_id, $meta_key, $meta_value );

    } // End check if this is the correct template
}







//  *****************************
//  Custom css for Posts and Pages
// ******************************
add_action( 'add_meta_boxes', 'mb_hdcss_add' );
function mb_hdcss_add() {
    
    $screens = array( 'post', 'page');
    $mb_context = 'normal';
    
    add_meta_box(   'meta-box-hdcss', 
                    'Add Css to the Title', 
                    'mb_hd_css', 
                    $screens, 
                     $mb_context, 
                    'high' );
}
function mb_hd_css( $post ) {
    wp_nonce_field( 'my_meta_box_nonce', 'meta_box_nonce' );
    ?>
    
    <div id="mb_hd_css-wrap" class="metabox-css-wrap" style="display:flex; " >
        <div class="metabox-col-wrap" style="display:flex; flex-direction: column">
                
            <label>Title CSS</label>
            
            <?php $hd_css_value = get_post_meta($post->ID, 'mb_hd_css', true);
            ?>
    
            <textarea  cols="40" rows="5" id="mb_hd_css" name="mb_hd_css" ><?php echo $hd_css_value; ?></textarea>

        </div> <!-- END .metabox-css-wrap -->
    </div> <!-- END .metabox-css-wrap -->
    
    <div id="mb_txt_css-wrap" class="metabox-css-wrap" style="display:flex; " >
        <div class="metabox-col-wrap" style="display:flex; flex-direction: column" >
            
            <label>Body CSS</label>
            
            <?php $txt_css_value = get_post_meta($post->ID, 'mb_txt_css', true);
            ?>
    
            <textarea  cols="40" rows="5" id="mb_txt_css" name="mb_txt_css" ><?php echo $txt_css_value; ?></textarea>
        </div> <!-- END .metabox-css-wrap -->
    </div> <!-- END .metabox-css-wrap -->
    
    
    <script>
        jQuery( document ).ready(function() {jQuery('#mb_hd_css-wrap').addClass('meta-panel-component').addClass('meta-panel-a');});
        
        jQuery( document ).ready(function() {jQuery('#mb_txt_css-wrap').addClass('meta-panel-component').addClass('meta-panel-b');});
        
        </script> 
    <?php
}
add_action( 'save_post', 'mb_hdcss_save' );
function mb_hdcss_save( $post_id ) {
    
    // Bail if we're doing an auto save
    if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
    // if our nonce isn't there, or we can't verify it, bail
    if( !isset( $_POST['meta_box_nonce'] ) || !wp_verify_nonce( $_POST['meta_box_nonce'], 'my_meta_box_nonce' ) ) return;
    // if our current user can't edit this post, bail
    if( !current_user_can( 'edit_post', $post_id ) ) return;
    // now we can actually save the data
    $allowed = array( 
        'a' => array( // on allow a tags
            'href' => array() // and those anchors can only have href attribute
        )
    );
        update_post_meta( $post_id, 'mb_hd_css', wp_kses( $_POST['mb_hd_css'], $allowed ) );
                
        update_post_meta( $post_id, 'mb_txt_css', wp_kses( $_POST['mb_txt_css'], $allowed ) );
}





































































?>