<!doctype html>

<html class="no-js " <?php language_attributes(); ?>>
    
<head>
    
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <meta name="description" content="<?php if ( is_single() ) {
            single_post_title('', true); 
        } else {
            bloginfo('name'); echo " - "; bloginfo('description');
        }
        ?>" />

  <!--[if lt IE 9]>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html5shiv/3.7.3/html5shiv.js"></script>
  <![endif]-->
  
  <?php wp_head(); ?>
  
</head>

<body <?php body_class('open-effect-1-init'); ?><?php echo $template_name; ?>>
    <!--
    *
    *   Section: Head and Nav
    *
    -->
    <div class="blog-masthead main-menu zindex900 handwriting">
        
    	<div class="container">
    	    
    	    <!-- Customizer data "Logo Image" in "Branding and Graphics"--> 
    	    <?php $logo_image = get_theme_mod( 'theme_logo_image', '' ); ?>
    	    
    	    <div id="nav-logo" class="theme-logo" style="background-image: url('<?php echo esc_url( $logo_image ); ?>')">
    	    </div>
    	    
    		<nav class="blog-nav zindex100 color1 trans">
    		    
    		    <div class="menu-title">Menu
    		    </div>
    		    
    		    <div id="menu-wrap" class="gi-main-menu color1 trans">
    		        
    		        <div class="gi-menu">
    		            
    			    <?php wp_nav_menu( array( 'theme_location' => 'header-menu' ) ); ?>
    			    
    			    </div> <!-- END .gi-menu -->
    			    
    			</div>
    			
    			<!-- The colorful lines beside the menu -->
    			<div id="navlin-wrap" class="trans" >
    			    
        			<div id="navline-horz" class="color2">
        			</div>
        			
        			<div id="navline-vert" class="color2">
        			</div>
        			
    			</div>
    			
    		</nav> <!-- END .blog-nav -->
    		
    	</div> <!-- END .container -->
    	
    </div> <!-- END .blog-masthead -->