<?php
// OPTIONS

$yourEmail = get_option( 'admin_email'); // the email address you wish to receive these mails through
$yourWebsite = get_option( 'blogname'); // the name of your website
$thanksPage = ''; // URL to 'thanks for sending mail' page; leave empty to keep message on the same page 
$maxPoints = 4; // max points a person can hit before it refuses to submit - recommend 4
$requiredFields = "name,email,comments"; // names of the fields you'd like to be required as a minimum, separate each field with a comma

//*** My Additions ***

$action_desired = '/gi-contact-form/';
$form_title = 'Reach Out Via Email';
$submit_name_prefix = 'gi';

// DO NOT EDIT BELOW HERE
$error_msg = array();
$result = null;

$requiredFields = explode(",", $requiredFields);

function clean($data) {
	$data = trim(stripslashes(strip_tags($data)));
	return $data;
}
function isBot() {
	$bots = array("Indy", "Blaiz", "Java", "libwww-perl", "Python", "OutfoxBot", "User-Agent", "PycURL", "AlphaServer", "T8Abot", "Syntryx", "WinHttp", "WebBandit", "nicebot", "Teoma", "alexa", "froogle", "inktomi", "looksmart", "URL_Spider_SQL", "Firefly", "NationalDirectory", "Ask Jeeves", "TECNOSEEK", "InfoSeek", "WebFindBot", "girafabot", "crawler", "www.galaxy.com", "Googlebot", "Scooter", "Slurp", "appie", "FAST", "WebBug", "Spade", "ZyBorg", "rabaz");

	foreach ($bots as $bot)
		if (stripos($_SERVER['HTTP_USER_AGENT'], $bot) !== false)
			return true;

	if (empty($_SERVER['HTTP_USER_AGENT']) || $_SERVER['HTTP_USER_AGENT'] == " ")
		return true;
	
	return false;
}
    $submit_button_name = $submit_name_prefix ."-submit";
if ($_SERVER['REQUEST_METHOD'] == "POST" && isset( $_POST[$submit_button_name] )) {
	if (isBot() !== false)
		$error_msg[] = "No bots please! UA reported as: ".$_SERVER['HTTP_USER_AGENT'];
		
	// lets check a few things - not enough to trigger an error on their own, but worth assigning a spam score.. 
	// score quickly adds up therefore allowing genuine users with 'accidental' score through but cutting out real spam :)
	$points = (int)0;
	
	$badwords = array("adult", "beastial", "bestial", "blowjob", "clit", "cum", "cunilingus", "cunillingus", "cunnilingus", "cunt", "ejaculate", "fag", "felatio", "fellatio", "fuck", "fuk", "fuks", "gangbang", "gangbanged", "gangbangs", "hotsex", "hardcode", "jism", "jiz", "orgasim", "orgasims", "orgasm", "orgasms", "phonesex", "phuk", "phuq", "pussies", "pussy", "spunk", "xxx", "viagra", "phentermine", "tramadol", "adipex", "advai", "alprazolam", "ambien", "ambian", "amoxicillin", "antivert", "blackjack", "backgammon", "texas", "holdem", "poker", "carisoprodol", "ciara", "ciprofloxacin", "debt", "dating", "porn", "link=", "voyeur", "content-type", "bcc:", "cc:", "document.cookie", "onclick", "onload", "javascript");

	foreach ($badwords as $word)
		if (
			strpos(strtolower($_POST['comments']), $word) !== false || 
			strpos(strtolower($_POST['name']), $word) !== false
		)
			$points += 2;
	
	if (strpos($_POST['comments'], "http://") !== false || strpos($_POST['comments'], "www.") !== false)
		$points += 2;
	if (isset($_POST['nojs']))
		$points += 1;
	if (preg_match("/(<.*>)/i", $_POST['comments']))
		$points += 2;
	if (strlen($_POST['name']) < 3)
		$points += 1;
	if (strlen($_POST['comments']) < 15 || strlen($_POST['comments']) > 1500)
		$points += 2;
	if (preg_match("/[bcdfghjklmnpqrstvwxyz]{7,}/i", $_POST['comments']))
		$points += 1;
	// end score assignments
	


    	if ( !empty( $requiredFields ) ) {
    		foreach($requiredFields as $field) {
    			trim($_POST[$field]);
    		
    			if (!isset($_POST[$field]) || empty($_POST[$field]) && array_pop($error_msg) != "Please fill in all the required fields and submit again.\r\n")
    				$error_msg[] = "Please fill in all the required fields and submit again.";
    					
    			if (!isset($_POST[$field]) || empty($_POST[$field])) {
    			    echo '<script>
    			            jQuery( window ).load(function() {
    			                jQuery("#footer-form #'.$field.'").addClass("form-error-field");
    			            });
    			          </script>';
    			}
    		}
    		
    	}
    
	if (!isset($_POST[$field]) || empty($_POST[$field])) {
    echo '<script>
        jQuery( window ).load(function() {
            jQuery( "<div></div>" ).addClass("form-error-arrow").insertBefore( ".form-error-field" );
        });
        
      </script>';
	}
	if (!empty($_POST['name']) && !preg_match("/^[a-zA-Z-'\s]*$/", stripslashes($_POST['name'])))
		$error_msg[] = "The name field must not contain special characters.\r\n";
	if (!empty($_POST['email']) && !preg_match('/^([a-z0-9])(([-a-z0-9._])*([a-z0-9]))*\@([a-z0-9])(([a-z0-9-])*([a-z0-9]))+' . '(\.([a-z0-9])([-a-z0-9_-])?([a-z0-9])+)+$/i', strtolower($_POST['email'])))
		$error_msg[] = "That is not a valid e-mail address.\r\n";
	if (!empty($_POST['url']) && !preg_match('/^(http|https):\/\/(([A-Z0-9][A-Z0-9_-]*)(\.[A-Z0-9][A-Z0-9_-]*)+)(:(\d+))?\/?/i', $_POST['url']))
		$error_msg[] = "Invalid website url.\r\n";
	if ($error_msg == NULL && $points <= $maxPoints) {
		$subject = $yourWebsite."Automatic Form Email";
		
		$message = "You received this e-mail message through your website: \n\n";
		foreach ($_POST as $key => $val) {

			if (is_array($val)) {
			   if ($key != $submit_button_name){
    				foreach ($val as $subval) {
    					$message .= ucwords($key) . ": " . clean($subval) . "\r\n";
    				}
			    }
			} else {
				$message .= ucwords($key) . ": " . clean($val) . "\r\n";
			}
		}
		$message .= "\r\n";
		$message .= 'IP: '.$_SERVER['REMOTE_ADDR']."\r\n";
		$message .= 'Browser: '.$_SERVER['HTTP_USER_AGENT']."\r\n";
		$message .= 'Points: '.$points;

		if (strstr($_SERVER['SERVER_SOFTWARE'], "Win")) {
			$headers   = "From: $yourEmail\r\n";
		} else {
			$headers   = "From: $yourWebsite <$yourEmail>\r\n";	
		}
		$headers  .= "Reply-To: {$_POST['email']}\r\n";

		if (mail($yourEmail,$subject,$message,$headers)) {
			if (!empty($thanksPage)) {
				header("Location: $thanksPage");
				exit;
			} else {
				$result = 'Your mail was successfully sent.';
				$disable = true;
			}
		} else {
			$error_msg[] = 'Your mail could not be sent this time. ['.$points.']';
		}
	} else {
		if (empty($error_msg))
			$error_msg[] = 'Your mail looks too much like spam, and could not be sent this time. ['.$points.']';
	}
}
function get_data($var) {
	if (isset($_POST[$var]))
		echo htmlspecialchars($_POST[$var]);
}
?>

<!-- Free PHP Mail Form v2.4.5 Copyright (c) Jem Turner 2007-2017 http://jemsmailform.com/ This program is free software: you can redistribute it and/or modify -->

<?php if (empty($result)) {
    ?>
<form class="contact-form" action="<?php echo $action_desired ?>" method="post">
    <h3><?php echo $form_title ?></h3>
    <?php
        if (!empty($error_msg)) {
        	echo '<p class="error">ERROR: '. implode("<br />", $error_msg) . "</p>";
        }
    ?>

<noscript>
		<p><input type="hidden" name="nojs" id="nojs" /></p>
</noscript>
<div id="name-email-boxes" class="input-box-wrap">
	<label for="name">Name: *</label> 
		<input type="text" name="name" id="name" placeholder="Your name..." value="<?php get_data("name"); ?>" /><br />
	
	<label for="email">E-mail: *</label> 
		<input type="text" name="email" id="email" placeholder="Email address..." value="<?php get_data("email"); ?>" /><br />
</div>	
<div id="footer-contact-comments">	
	<label for="comments">Comments: *</label>
		<textarea name="comments" id="comments" rows="5" cols="20" placeholder="Comments..." ><?php get_data("comments"); ?></textarea><br />

    <?php 
    
    // record current URl to pass with post in order to return after success
    if (empty($_POST['return-page-url'])) {
    $query_args = array();

    $query = wp_parse_url( $YOUR_URL );

    $permalink = get_option( 'permalink_structure' );

    if ( empty( $permalink ) ) {

        $query_args = $query['query'];

    }

    $return_page_url = home_url( add_query_arg( $query_args , $wp->request ) );
    } else {
        $return_page_url = $_POST['return-page-url'];
    }
    ?>
    <input type="hidden" name="return-page-url" id="return-page-url"  value="<?php echo $return_page_url; ?>" />
	<input type="submit" name="<?php echo $submit_name_prefix ?>-submit" id="submit" value="Let's GO!" <?php if (isset($disable) && $disable === true) echo ' disabled="disabled"'; ?> />

</div>
</form>
<?php   }  ?>

    <?php
        if ($result != NULL) {
            ?>
        	<p class="success"><?php echo $result ?></p>

    
            <a class="return-page-url" href= "<?php echo $_POST['return-page-url'];?>">Return to <?php echo $_POST['return-page-url'];?></a>
            <?php pagenav_special_post() ?>
    <?php

    }
    ?>

