(function($) {



 /******************************
 *
 *     Menu and Navigation
 *
 ******************************/

function menuAnimationOnLoad() {

    //  Set the menu and nav bars to
    //  ainitial state Override Transition
    //  setting to make instant.
    $('.gi-main-menu').css('transition', '0s')
        .addClass('gi-mainmenu-trans');

    $('#navline-horz, #navline-vert')
        .css('transition', '0s').css('opacity','0');

    $('#navline-horz, #navline-vert').hide(325,

        function() {

            $('.gi-main-menu, #navline-horz, #navline-vert').css('transition', '').css('opacity','');

            $('#navline-horz, #navline-vert').show(1500);

        });

        setTimeout(
            function() {
                $('.gi-main-menu').removeClass('gi-mainmenu-trans');

        }, 750);
}
menuAnimationOnLoad();





function initializeMenuChildren() {

    $('.gi-menu').children().addClass('gi-menu-list color1')
        .append('<btn class="main-menu-close trans-ease75">X</btn>').hide();

    $('.page_item_has_children').addClass('gi-menu-parent').addClass('menu-closed').children('ul').addClass('sub-menu').hide();

    $('.menu-item-has-children').addClass('gi-menu-parent').addClass('menu-closed').children('ul').addClass('sub-menu').hide();

    $('.gi-menu-parent').children().addClass('submenu-children').children().addClass('submenu-children-links');

    $('.gi-menu-parent').each(function() {

        var cntr = 0;

        $(this).prepend('<button id="close-' +  $(this).attr('id') +'" class="close-submenu" ></button> ');

        $(this).children('.sub-menu.submenu-children').each(function() {

            cntr++;

            $(this).addClass('submenu-child-' + cntr);

        });

    }); //  END .gi-menu-parent.each

    $('.close-submenu').on('click', function() {

        $(this).parent('.gi-menu-parent').toggleClass('menu-closed').toggleClass('menu-open').children('.sub-menu').stop().slideToggle('slow');
    });

}
initializeMenuChildren();





//  Change horizontal menu to a hidden list if it is too long
function menuToHiddenList() {

    var parentWidth = ($('.blog-nav').width())* 0.33; 
    var thisWidth = $('.blog-nav').width();

    if (thisWidth >= parentWidth ) { 

        $('.blog-nav').addClass('menu-collapsed');

    }

}
menuToHiddenList();





function menuOpenClose() {

    //  Elements that can toggle the menu
    var menuTitleElm = '.blog-nav .menu-title';
    var menuLogoElm = '.blog-masthead #nav-logo';
    var menuCluseBtn = '.main-menu-close';
    var menuToggle2 = '.blog-nav';
    var menuMainElm = '.gi-menu-list';


    $(menuTitleElm + ', ' + menuLogoElm + ', ' + menuToggle2).on('click', function(event) {

            //  Toggle the menu title text
            $(menuTitleElm).text($(menuTitleElm).text() === 'Close' ? 'Menu' : 'Close').toggleClass('menu-title-open');

            //  If the menu was closed, show the "close" button
            //  and bind a click to the button and the page
            if ( $('.gi-menu-list').css('display') === 'none' ) {

                $(menuCluseBtn).show('normal');

                $('html, ' + menuCluseBtn).on('click',
                    function() {

                        $('html, ' + menuCluseBtn).off('click');

                        $(menuCluseBtn).slideUp('fast');

                        $(menuTitleElm).text($(menuTitleElm).text() === 'Close' ? 'Menu' : 'Close').toggleClass('menu-title-open');

                        $(menuMainElm).slideToggle('');

                });

            } else {

                $(menuCluseBtn).hide('fast');

                $('html, ' + menuCluseBtn).off('click');
            }

            $(menuMainElm).slideToggle('');

            event.stopPropagation();

        });



        $(menuTitleElm + ', ' + menuLogoElm + ', ' + menuMainElm).click(function(event){
            event.stopPropagation();
        });


}
menuOpenClose();





function menuShrinkOrMove() {

    var menuTitleWidth = $(".blog-nav .menu-title").width();
    var menuWidth = menuTitleWidth + 50; // Add 50 to accomdate margins


    //  Make menu title vertical
    //  to prevent it from spilling
    //  over into the content.
    function menuShrinkVirtical() {

        // Check content's destance from the left edge
        var contentOffset = $('.site-content').offset().left;
        //  Add 70 to accomodate the content's left margin
        contentOffset = contentOffset - 70;

        if ( menuWidth > (contentOffset) ) {

        	$('.container').addClass('left-side');

        } else {

            $('.container').removeClass('left-side');

        }
    }

    menuShrinkVirtical();


    function menuMoveToTop() {

        var ScreenWidth = window.innerWidth;

        if ( ScreenWidth <= 600 ) {

        	$('.container').addClass('top-menu').removeClass('left-side');

        } else {

            $('.container').removeClass('top-menu');

        }
    }

    menuMoveToTop();


    $( window ).resize(function() {

      menuShrinkVirtical();

      menuMoveToTop();

    });

}
menuShrinkOrMove();





//  Customizer setting
//  'Hide Admin on Frontend'
//  this var will be populated
//  on page load from kirki-config.php
if (topBarSetting !== 1) {

    $('div#wpadminbar').hide();

    $('html').attr('style', 'margin-top: 0 !important');

}





var quoteEffect1;
var scrollPosition;
var quoteDivTop;
var MiddleScrollRAW = 0;
var sectionTitle = 0;
var opacitySet;
var maxScrollAmount;
var retreatSpeed;
var scaleSet;
var imageWrapHeight;


//  If enabled, move top back or
//  forward on scroll up or down
function topFixedScrollEffect() {

    // Set the opacity and scale as the page scrolls
    opacitySet = 1 - (scrollPosition/maxScrollAmount);
    maxScrollAmount = 630;
    retreatSpeed = 70; // Higher the number, the slower the retreat
    scaleSet = 1 - ((scrollPosition/retreatSpeed)/maxScrollAmount);
    imageWrapHeight = $('#top-content-wrap').outerHeight( true );
    imageWrapHeight = imageWrapHeight + ($(window).width() * 0.05);

    $('#front-page #top-section').css('height', imageWrapHeight + 'px');

    $('#front-page #top-content-wrap').addClass('fixed-centered').css('opacity', opacitySet ).css('transform', 'scale(' + scaleSet + ') ');

}
topFixedScrollEffect();

$( window ).resize(function() {

    topFixedScrollEffect();

    });





//  Dark color for transitions
var safeColor = '#333';
var divTop;
var divHeight;
var divBottom;
var thisID;
var topDivColor;
var css;
var bg_color;
var topDivBGColor;
var alpha;

// change the menu color and title as the page scrolls
function menuColorOnScroll() {

    $('.section').each(function(index){

        divTop = $(this).position().top - $(window).scrollTop();
        divHeight = $(this).outerHeight();
        divBottom = divTop + divHeight;
        thisID = $(this).attr('id');
        sectionTitle = $(this).find('.gi-section-title');
        topDivColor = $(this).css('color');
        css = $(this).css('background');
        bg_color = $(this).css('background-color');
        topDivBGColor = bg_color;
        alpha = bg_color.replace(/^.*,(.+)\)/,'$1');

        if (divTop < 0 && divBottom  > 50) {

            $('nav.blog-nav').css('color', topDivColor).css('text-shadow', '-1px -1px 0px ' + bg_color);

            if (divTop < 0 && divBottom  < 250 && divBottom  > 0) {

                if (alpha < 1) {

                 $('nav.blog-nav').css('color', safeColor);

                }
            }
        }
    });
}





function menuLinesShrinkOnScroll() {

    if (scrollPosition > 50) {
    $('#navlin-wrap').addClass('small-navline');
    }

    if (scrollPosition <= 50) {
    $('#navlin-wrap').removeClass('small-navline');
    }

}







 /******************************
 *
 *     Fixed Footer Form
 *
 ******************************/
function createFixedContactForm() {

    $('#footer-form').clone().addClass('fixed-form').addClass('color-footer').appendTo('#fixed-form-wrap').prepend('<button class="close-btn">X</button>');

    $('#footer-form-wrap').prepend('<button class="close-btn">X</button>');

    $('#fixed-form-wrap input#submit').appendTo('#fixed-form-wrap #name-email-boxes');

    $('#fixed-form-wrap input#name, #fixed-form-wrap input#email')
        .on('mouseenter',
            function() {

                var curOpacity = $('#fixed-form-wrap').css('opacity');

                if(curOpacity !== 0) {

                    $('#fixed-form-wrap').addClass('fixed-form-wrap-open');

                }
            });

    $('#fixed-form-wrap').on('mouseleave', function() {
        $('#fixed-form-wrap').removeClass('fixed-form-wrap-open');
    });

    $('body').on('mouseleave', function() {
        $('#fixed-form-wrap').removeClass('fixed-form-wrap-open');
    });


    $('footer').prepend('<button class="footer-form-btn open-btn ">^ Reach out ^</button>');

    $('.footer-form-btn.open-btn').hide();

    $('#footer-form .close-btn, .footer-form-btn.open-btn').on('click', function() {

            if($('#fixed-form-wrap').is(':hidden')) {
            setTimeout(
                function() {

                    $('#fixed-form-wrap').slideToggle('slow');

                },700);

                } else {

                    $('#fixed-form-wrap').slideToggle('slow');

                }

            if($('.footer-form-btn.open-btn').is(':hidden')) {
                setTimeout(
                    function() {

                        $('.footer-form-btn.open-btn').slideToggle('slow');

                    },700);

                    } else {

                        $('.footer-form-btn.open-btn').slideToggle('slow');

                    }
    });


}
createFixedContactForm();





var fixedFormScrlTrig;
function hideFixedFormAtBottom() {

    fixedFormScrlTrig = $(document).height() - ($('#pre-footer-section').height() + $('footer').height());

    if (scrollPosition + $(window).height() - 200 > fixedFormScrlTrig || scrollPosition < 300) {
                 $('#fixed-form-wrap').css('opacity', 0).css('height',0);

    } else {

         $('#fixed-form-wrap').css('opacity','').css('height','');

    }
}
hideFixedFormAtBottom();







 /******************************
 *
 *     Quote Section Effect
 *
 ******************************/
function ensureQuotesDontTouch() {
    var quoteHeight;
    var theTop;
    var oldWinScrollTop;
    oldWinScrollTop = $(window).scrollTop();
    //  Set quote1b in relation to quote1a's height
    quoteHeight = $('.home #quote1a .page-quote').css('height');
    theTop = $(thisQuote).offset().top;
}





var thisQuote;
var wndwHgt;
var quoteDivHeight;
var quoteDivMiddle;
var qtMidTrigger;
var qtScrollActivate;
var qtScrollDeactivate;
var qtScrollActDeactMiddle;
var MiddleScrollPercent;

function quoteOpacityOnScroll() {


    //  Display quote aeras as they pass into view
    $('.quote-area').each(function(index){

        wndwHgt = $(window).height();
        thisQuote = $(this).find('.page-quote');
        quoteDivTop = $(this).position().top - scrollPosition;
        quoteDivHeight = (wndwHgt - $(this).outerHeight()) / 2 + $(this).outerHeight();
        quoteDivMiddle = quoteDivTop + (quoteDivHeight/2);
        qtMidTrigger = -Math.abs(quoteDivHeight/2);
        qtScrollActivate = 0.0 * wndwHgt;
        qtScrollDeactivate = 2 * wndwHgt;
        qtScrollActDeactMiddle = (qtScrollDeactivate - qtScrollActivate)/2;
        MiddleScrollPercent = 1.7-(Math.abs((((qtScrollDeactivate - qtScrollActivate)/2)-quoteDivMiddle)/200));
        MiddleScrollRAW = -(quoteDivMiddle - qtScrollActDeactMiddle)/10;
        opacityFadeAdjustment = 4.5;

        // See if the element middle is between the activation markers
        if (quoteDivMiddle > qtScrollActivate - 300 && quoteDivMiddle  <  qtScrollDeactivate) {

            console.log('IN');


            // Record that the element has been activated
            quoteEffect1 = 1;  

            $( thisQuote ).css( 'opacity', MiddleScrollPercent + opacityFadeAdjustment ).css('transform', 'translate(-50%,-' + (50 +  MiddleScrollRAW) + '%)');

            if (MiddleScrollPercent >= -2) {

                $(thisQuote).fadeIn('fast');
            }

        }
console.log('quoteDivMiddle qtMidTrigger', quoteDivMiddle, qtMidTrigger - 100);
        // See if the element has been activated
        if (quoteEffect1 === 1 ) {

            if (quoteDivMiddle <= qtMidTrigger -100 || quoteDivMiddle >= quoteDivHeight + 100) {
                    quoteEffect1 = 0;  

                    $(thisQuote).css('opacity', "" );

            }
        }
     });
}





//  Quote section, the menu and the fixed form all have scroll-activated reactions. Refreshing the page over one of these elements will show the element without the being affected by scrolling. the following solves that issue without adding a ton of additional logic to each.
window.scrollTo(window.scrollX, window.scrollY + 1);







 /******************************
 *
 *      Window On Scroll
 *
 ******************************/


$( window ).scroll(function() {
    
    menuLinesShrinkOnScroll();
    
    menuColorOnScroll();

    scrollPosition = $(window).scrollTop();

    topFixedScrollEffect();

    hideFixedFormAtBottom();

    quoteOpacityOnScroll();





});// END of window.on scroll




})( jQuery );