<?php

/********************
 *  
 *   Load Files
 * 
********************/

//  Load basic files
function load_humanconnection_scripts() {
    
    wp_enqueue_style( 'style-main', get_stylesheet_uri() );
    
    wp_enqueue_style( 'style-google', 'https://fonts.googleapis.com/css?family=Give+You+Glory|La+Belle+Aurore', false );
    
    wp_enqueue_style( 'style-responsive', get_template_directory_uri().'/css/responsive.css');
    
    wp_enqueue_script('my-custom-script', get_template_directory_uri() .'/js/scripts.js', array('jquery'), null, true);
    
}
add_action( 'wp_enqueue_scripts', 'load_humanconnection_scripts' );


//  Load basic files
function load_late_scripts() {

    //  Pull Masonry from the WordPress core
    wp_enqueue_script( 'masonry' );
   
}
add_action( 'print_late_styles', 'load_late_scripts' );


//  Loads color picker data in the admin area, mainly for use in the editor metaboxes
add_action( 'admin_enqueue_scripts', 'wp_enqueue_color_picker' );
function wp_enqueue_color_picker( $hook_suffix ) {
    wp_enqueue_style( 'wp-color-picker' );
    wp_enqueue_script( 'wp-color-picker');
}


//  Load Kirki Framework and configure it
//  From: https://aristath.github.io/kirki/
//  require __DIR__ . '/assets/kirki/kirki.php';
include_once __DIR__ . '/inc/class-kirki-installer-section.php' ;
include_once __DIR__ . '/inc/class-gi-theme-kirki.php' ;
require __DIR__ . '/assets/kirki-config.php';



/********************
 *  
 *   Sidebars and
 *      Widgets
 * 
********************/

//  Register sidebars
function gi_theme_sidebar() {
    register_sidebar(
        array (
            'name' => __( 'Sidebar', 'human-connection' ),
            'id' => 'theme-side-bar',
            'description' => __( 'Display widgets on posts and pages (other than the Home page', 'human-connection' ),
            'before_widget' => '<div class="widget-content">',
            'after_widget' => "</div>",
            'before_title' => '<h3 class="widget-title">',
            'after_title' => '</h3>',
        )
    );
    
    register_sidebar(
        array (
            'name' => __( 'Single Post Sidebar', 'human-connection' ),
            'id' => 'single-post-sidebar',
            'description' => __( 'Display widgets only on single-post pages', 'human-connection' ),
            'before_widget' => '<div class="widget-content single-post-widgetarea">',
            'after_widget' => "</div>",
            'before_title' => '<h3 class="widget-title">',
            'after_title' => '</h3>',
        )
    );

}
add_action( 'widgets_init', 'gi_theme_sidebar' );


//  Footer widget areas
function glassinteractive_widgets_init() {
	//  First footer widget area
	register_sidebar(array(
		'name' =>__( 'First Footer Widget Area', 'human-connection'),
		'id' => 'first-footer-widget-area',
		'description' =>__( 'The first footer widget', 'human-connection'),
		'before_widget' =>'<div id="%1s" class="widget-container %2$s">',
		'after_widget' =>'</div>',
		'before_title' =>'<h3 class="widget-title">',
		'after_title' => '</h3>',
	));
	//  Second footer widget area
	register_sidebar(array(
		'name' =>__( 'Second Footer Widget Area', 'human-connection'),
		'id' => 'second-footer-widget-area',
		'description' =>__( 'The second footer widget', 'human-connection'),
		'before_widget' =>'<div id="%1s" class="widget-container %2$s">',
		'after_widget' =>'</div>',
		'before_title' =>'<h3 class="widget-title">',
		'after_title' => '</h3>',
	));
	//  Third footer widget area
	register_sidebar(array(
		'name' =>__( 'Third Footer Widget Area', 'human-connection'),
		'id' => 'third-footer-widget-area',
		'description' =>__( 'The third footer widget', 'human-connection'),
		'before_widget' =>'<div id="%1s" class="widget-container %2$s">',
		'after_widget' =>'</div>',
		'before_title' =>'<h3 class="widget-title">',
		'after_title' => '</h3>',
	));
	//  Fourth footer widget area
	register_sidebar(array(
		'name' =>__( 'Fourth Footer Widget Area', 'human-connection'),
		'id' => 'fourth-footer-widget-area',
		'description' =>__( 'The fourth footer widget', 'human-connection'),
		'before_widget' =>'<div id="%1s" class="widget-container %2$s">',
		'after_widget' =>'</div>',
		'before_title' =>'<h3 class="widget-title">',
		'after_title' => '</h3>',
	));

}
add_action('widgets_init', 'glassinteractive_widgets_init', 7);



/********************
 *  
 *  Posts and Pages
 * 
********************/


// Force home.php if going to "Home". This ensures the masonry display for the home page, while still allowing a seperate Fonr Page to use front-page.php
function themeslug_filter_front_page_template( $template ) {
    return is_home() ? '' : $template;
}
add_filter( 'frontpage_template', 'themeslug_filter_front_page_template' );


function front_page_template( $template ) {

	if ( is_front_page() ) {
	    
	    $front_page_posts_or_static = get_option( 'show_on_front' );

	    if ( true == get_theme_mod( 'front_page_selection', true ) ) {
	        $new_template = locate_template( array( 'front-page.php' ) );
        		if ( !empty( $new_template ) ) {
        			return $new_template;
        		}
	    } elseif($front_page_posts_or_static === 'page') {
	        
	        	$new_template = locate_template( array( 'page.php' ) );
        		if ( !empty( $new_template ) ) {
        			return $new_template;
        		}
	    } else {
	            $new_template = locate_template( array( 'home.php' ) );
        		if ( !empty( $new_template ) ) {
        			return $new_template;
        		}
	    }	    
	    
	}

	return $template;
}
add_filter( 'template_include', 'front_page_template', 99 );


// Force the contact form template if gi-contact-form is in the url
add_action('init', function() {
  $url_path = trim(parse_url(add_query_arg(array()), PHP_URL_PATH), '/');
  if ( $url_path === 'gi-contact-form' ) {
     // load the file if exists
     $load = locate_template('gi_contact_results.php', true);
     if ($load) {
        exit(); // just exit if template was found and loaded
     }
  }
});


add_theme_support( 'post-thumbnails' );


//  Add page excerpts.
add_post_type_support( 'page', 'excerpt', 1 );
function register_my_menus() {
  register_nav_menus(
    array(
      'header-menu' => __( 'Header Menu', 'human-connection' ),
      'extra-menu' => __( 'Extra Menu', 'human-connection' )
    )
  );
}
add_action( 'init', 'register_my_menus' );


//  Add body classes
add_filter( 'body_class','my_body_classes' );
function my_body_classes( $classes ) {
    
        //  If the page is the "home" or "blog" page, the class will not be automatically included. To address this, we create the page class or post class and force it. If it is the page is not "home" or "blog", the class will not appear twice.
    
        $id = get_the_ID();
        if( is_page() ) {
            $curPgClass = 'page-id-'.$id;

        } else { 
             $curPgClass = 'postid-'.$id;
  
         }
         
    //  Now, add the class to the array to force it.    
    $classes[] = $curPgClass;
     
    return $classes;
     
}


//  Set Content Width
if ( ! isset( $content_width ) ) {
	$content_width = 1200;
}


//  Add title_tag support
add_theme_support( 'title-tag' );
if ( ! function_exists( '_wp_render_title_tag' ) ) {
	function theme_slug_render_title() {
?>
<title><?php wp_title( '|', true, 'right' ); ?></title>
<?php
	}
	add_action( 'wp_head', 'theme_slug_render_title' );
}


//  Add support for custom post formats
add_theme_support('post-formats', array( 'aside', 'chat', 'gallery', 'image', 'link', 'quote', 'status', 'video', 'audio'));


//  Add comments js only if the comment form is 
//  loaded and threaded comments are enabled
function xtreme_enqueue_comments_reply() {
	if( get_option( 'thread_comments' ) )  {
		wp_enqueue_script( 'comment-reply' );
	}
}


//  Disable HTML in Comments 
//add_filter('comment_text', 'wp_filter_nohtml_kses');
//add_filter('comment_text_rss', 'wp_filter_nohtml_kses');
//add_filter('comment_excerpt', 'wp_filter_nohtml_kses');


//  Replace default avatar
add_filter( 'avatar_defaults', 'wpb_new_gravatar' );
 
function wpb_new_gravatar ($avatar_defaults) {
 
$myavatar = get_template_directory_uri() . '/images/default_avatar7.png';
 
$avatar_defaults[$myavatar] = "Human Connection Default";
 
return $avatar_defaults;
 
}


//  Add Rss Feeds automatcally via the <head>
add_theme_support( 'automatic-feed-links' );
add_theme_support( 'automatic-feed-links' );


//  Make all Featured images linkable to their post, 
//  while allowing featured images on a single post page to link to the poto.
function link_featured_images( $html, $post_id, $post_image_id ) {
 
If (! is_singular()) { 
     
$html = '<a href="' . get_permalink( $post_id ) . '" title="' . esc_attr( get_the_title( $post_id ) ) . '">' . $html . '</a>';
return $html;
 
} else { 
 
return $html;
 
}
 
}
add_filter( 'post_thumbnail_html', 'link_featured_images', 10, 3 );




/********************
 *  
 *   Navigation
 * 
********************/

//  Basic post navigation
function postnav_standard() {
    ?>

    <div class="postnav-outerwrap postnav-standard">
        <h4>Post Navigation</h4>
        <div class="pagenav-wrap">
                            
            <div class="previous"><?php next_post_link( '%link', '&larr; %title' ); ?>
            </div>
            
            <div class="next "><?php previous_post_link( '%link', '%title &rarr;' ); ?>
            </div>
        
        </div> <!-- /END .pagenav-wrap -->
    </div> <!-- /END .postnav-outerwrap -->
    <?php
}  

//  Post navigation with a number bar
function postnav_numberbar() {
        global $wp_query;
 
    $total_pages = $wp_query->max_num_pages;
        if ($total_pages > 1){
    ?>
    <div class="postnav-outerwrap">
        <h4>Post Navigation</h4>
        <div class="pagenav-wrap">
            <?php pagination_numberbar(); ?>
        </div> <!-- /END .pagenav-wrap -->
    </div> <!-- /END .postnav-outerwrap -->   
    <?php
    }
}

//  Basic page navigation                       
function pagenav_standard() {
    ?>
    <div class="pagenav-outerwrap pagenav-standard">
                <h3>Page Navigation</h3>
        <div class="pagenav-wrap">
            <div class="pagenav-holder"></div>
        </div><!-- /END .pagenav-wrap -->  
            
            <!-- Page list -->
            <div class="pagenav-outerwrap pagenav-special-post">
                <div class="pagenav-wrap">

                    <h4>Page List</h4>
                <div class="pagenav-list-wrap">
                        <div class="pagenav-holder">
                            <?php wp_nav_menu( array( 'theme_location' => 'header-menu' ) ); ?>
                        </div>
                    </div>
                 </div> <!-- /END .pagenav-wrap --> 
                 <div class="arrow">q</div>
            </div> <!-- /END .pagenav-outerwrap -->
         
    </div> <!-- /END .pagenav-outerwrap.pagenav-standard -->
    <script>
            (function($) {
                $(window).load(function(){
                // Page Navigation via Main Menu
                var prevPageName = $('.current_page_item, .current_page_parent').prev('.menu-item').children('a').first().text();
                var nextPageName = $('.current_page_item, .current_page_parent').next('.menu-item').children('a').first().text();
                var prevPageId = '#' + $('.current_page_item, .current_page_parent').prev('.menu-item').attr('id');
                var nextPageId = '#' + $('.current_page_item, .current_page_parent').next('.menu-item').attr('id');
                var prevPageUrl = $(prevPageId + ' a').attr('href');
                var nextPageUrl = $(nextPageId + ' a').attr('href');
                console.log('prevPageName:', prevPageName);
                console.log('nextPageName:', nextPageName);
                console.log('prevPageId:', prevPageId);
                console.log('nextPageId:', nextPageId);
                console.log('prevPageUrl:', prevPageUrl);
                console.log('nextPageUrl:', nextPageUrl);
                


                
                if (prevPageUrl) {
                    $('.pagenav-standard .pagenav-holder').append('<div class="pagenav-prev previous"><a href="' + prevPageUrl + '"><span>q</span>' + prevPageName + '</a></div>');
                }
                if (nextPageUrl) {
                    $('.pagenav-standard .pagenav-holder').append('<div class="pagenav-next next"><a href="' + nextPageUrl + '">' + nextPageName + '<span>q</span></a></div>');
                }
                
                // Page list
                $('.pagenav-special-post').hover(function() {
                    $(this).children('.pagenav-wrap').addClass('pagenav-open');
                    $(this).children('.arrow').addClass('pagenav-open');
                    }, function() {
                       $(this).children('.pagenav-wrap').removeClass('pagenav-open'); 
                       $(this).children('.arrow').removeClass('pagenav-open');
                    });
                
                });

            })( jQuery );
            </script>
    <?php

}

//  Page navigation with a number bar
function pagination_numberbar() {
    global $wp_query;
 
    $total_pages = $wp_query->max_num_pages;
 
    if ($total_pages > 1){
        $current_page = max(1, get_query_var('paged'));
        echo '<div class="page-navigation numberbar" role="navigation">';
        echo paginate_links(array(
            'base' => get_pagenum_link(1) . '%_%',
            'format' => '/page/%#%',
            'current' => $current_page,
            'total' => $total_pages,
        ));
        echo '</div> <!-- /END .page-navigation -->';
    }
}

// Special page nav: a collapsable page list
function pagenav_special_post() {
    ?>
    <div class="pagenav-outerwrap pagenav-special-post">
        <div class="pagenav-wrap">
            <h3>Page Navigation</h3>
            <div class="pagenav-holder">
                <?php wp_nav_menu( array( 'theme_location' => 'header-menu' ) ); ?>
            </div>
         </div> <!-- /END .pagenav-wrap --> 
         <div class="arrow">q</div>
    </div> <!-- /END .pagenav-outerwrap -->
     <script>
            (function($) {
                $(document).ready(function(){
                $('.pagenav-special-post').hover(function() {
                    $(this).children('.pagenav-wrap').addClass('pagenav-open');
                    $(this).children('.arrow').addClass('pagenav-open');
                    }, function() {
                       $(this).children('.pagenav-wrap').removeClass('pagenav-open'); 
                       $(this).children('.arrow').removeClass('pagenav-open');
                    });
                });
                
            })( jQuery );
            </script>
   
    <?php
    
}


//  "Read More" Default Replacment
// Replaces the excerpt "Read More" text by a link
function new_excerpt_more($more) {
       global $post;
	return ;
}
add_filter('excerpt_more', 'new_excerpt_more');


//Force read more link on all excerpts
	function get_read_more_link() {
		$excerpt = get_the_excerpt();
		return '<p>' . $excerpt . '&nbsp;<a class="moretag" href="'. get_permalink($post->ID) . '">Continue reading <span>q</span></a></p>';
	}
	add_filter( 'the_excerpt', 'get_read_more_link' );
	

	
/********************
 *  
 *  Post and Page
 *  Editor Manipulation
 * 
********************/	


//  Add default editor style.css. A custom css file can be used instead via add_editor_style( 'css/custom-editor-style.css' );
add_editor_style();


//  Include the metabox php file  and if in the page editor, the CSS
include_once __DIR__ . '/inc/gi_meta_boxes/metabox_pages.php' ;
function metaboxes_for_page_editor() {

    global $my_admin_page;
    $screen = get_current_screen();

    if ( is_admin() && ($screen->post_type== 'page') ) {
         add_action( 'admin_print_styles-post-new.php', 'portfolio_admin_style', 11 );
    add_action( 'admin_print_styles-post.php', 'portfolio_admin_style', 11 );
    
    function portfolio_admin_style() {
    
            wp_enqueue_style( 'portfolio-admin-style', get_stylesheet_directory_uri() . '/css/admin_editor_page.css' );
    }
      //return $screen->post_type;
    }
}

add_action( 'add_meta_boxes_page', 'metaboxes_for_page_editor' );


//  Add post format meta box to a new position
function add_post_format_box() {
    add_meta_box( 
        'formatdiv', 
        _x( 'Format', 'post format' ),    // for translation
        'post_format_meta_box',    // use the same wordpress already defined function
        'post', 
        'side',   // context
        'high'    // priority in that context
    );
}
add_action( 'add_meta_boxes', 'add_post_format_box');


//  Move all "advanced" metaboxes above the default editor
//  This was modified to use a custom context, but originated 
//  from Andrew at https://wordpress.stackexchange.com/a/88103.
add_action('edit_form_after_title', function() {
    global $post, $wp_meta_boxes;
    do_meta_boxes(get_current_screen(), 'gi_after_title', $post);
    unset($wp_meta_boxes[get_post_type($post)]['gi_after_title']);
});


//  Checks for special text or
//  else returns appropriate blog info
function theme_mod_detail($theme_mod_setting, $default_Output) {
    
    //  Store setting from Customizer 
    //  with $default_Output as the fallback
    $theme_mod_output = trim( get_theme_mod( $theme_mod_setting, $default_Output ) );
    
    //  See if we are seeking the  site name
    //  or description and get the desired 
    //  data. Otherwise, return the site URL
    if( $theme_mod_output === 'name' || $theme_mod_output === 'description' ) {
        
        $theme_mod_output = get_bloginfo( $theme_mod_output);
        
    } elseif( $theme_mod_output === 'wpurl' ) {
        
        $theme_mod_output = parse_url(get_bloginfo( $theme_mod_output) )['host'];
    }
    return $theme_mod_output;
}


//  Function to check for a Welcome Image
//  set for the Front Page. If not, use the default image.
function theme_mod_bkgrnd_image($theme_mod_setting) {
    $theme_mod_output = get_theme_mod( $theme_mod_setting);
    if( $theme_mod_output !== '' ) {
        $theme_mod_output = 'style="background-image: url('.$theme_mod_output.')"';
    };
    return $theme_mod_output;
}


//  For use in page templates to support custom 
//  titles and descriptions used in the page editor metaboxes
function check_page_type($desired_output) {
    if ($desired_output == 'title'){
        if (is_home()) { 

            	$output = bloginfo('name');
            	return $output;
            
            } else { 
            
                $output = the_title();
                return $output;
            }
        
    }
    if ($desired_output == 'desc') {
        if (is_home()) { 

            	$output = bloginfo('description');
            	
            	return $output;
            
            } else { 
                
            	$output = get_the_excerpt();
            	echo 'output: ';
            	return $output;
            }
    }
}


//  For use in page templates to support custom colors
//  for titles and body text used in the page editor metaboxes
function mb_color_title_bckgrnd()  {
    global $post;
    $meta_key_title_txt = 'mb_post_class_eight';
    if ( metadata_exists( 'post', $post->ID, $meta_key_title_txt ) ) {
        $meta_key_title_txt = get_post_meta( $post->ID, $meta_key_title_txt, true );
    } else {
        $meta_key_title_txt = '';
    }
    
    $meta_key_body_txt = 'mb_post_class_nine';
    if ( metadata_exists( 'post', $post->ID, $meta_key_body_txt ) ) {
        $meta_key_body_txt = get_post_meta( $post->ID, $meta_key_body_txt, true );
    } else {
        $meta_key_body_txt = '';
    }
    
?>
   
    <style>
    
        <?php  if($meta_key_title_txt !== '') : ?>
        
            #page-title-wrap {
                
                color:<?php echo $meta_key_title_txt ?>;
                
            }
        <?php endif ?>
        
        <?php if($meta_key_body_txt !== '') : ?>
        
             #standard-page #primary {
                 
                color:<?php echo $meta_key_body_txt ?>;
            }
        
        <?php endif ?>
    </style>
<?php
}
add_action( 'print_late_styles', 'mb_color_title_bckgrnd' );



/********************
 *  
 *    Database 
 *    Functions
 * 
********************/	

function setupdb_color_palette() {

    global $gicp_db_version;
    $gicp_db_version = '1.0';
    
    function gicpl_install() {
    	global $wpdb;
    	global $gicp_db_version;
    
    	$table_name = $wpdb->prefix . 'color_palettes';
    	
    	$charset_collate = $wpdb->get_charset_collate();
    
    	$sql = "CREATE TABLE IF NOT EXISTS $table_name (
    		id mediumint(9) NOT NULL AUTO_INCREMENT,
    		time datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
    		name tinytext NOT NULL,
    		color1 text NOT NULL,
    		color2 text NOT NULL,
    		color3 text NOT NULL,
    		color4 text NOT NULL,
    		color5 text NOT NULL,
    		color6 text NOT NULL,
    		color7 text NOT NULL,
    		url varchar(55) DEFAULT '' NOT NULL,
    		PRIMARY KEY  (id)
    	) $charset_collate;";
    
    	require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
    	dbDelta( $sql );
    
    	add_option( 'gicp_db_version', $gicp_db_version );
    }
    
    function gicp_install_data() {
    	global $wpdb;

        	$palette_name = 'default';
        	$color1 = '#fcf8df';
        	$color2 = '#5FA9BC';
        	$color3 = '#9ACDDD';
        	$color4 = '#D5C2D4';
        	$color5 = '#eae1ea';
        	$color6 = '#fdf5ec';
        	$color7 = '#474747';
        	
        	$table_name = $wpdb->prefix . 'color_palettes';
        	
        	$wpdb->replace( 
        		$table_name, 
        		array(
        		    
        		    'id'     => '1',
        			'time'   => current_time( 'mysql' ), 
        			'name'   => $palette_name, 
        			'color1' => $color1,
        			'color2' => $color2,
        			'color3' => $color3,
        			'color4' => $color4,
        			'color4' => $color4,
        			'color5' => $color5,
        			'color6' => $color6,
        			'color7' => $color7,
        
                ) 
            );

            $palette_name = 'custom';
            $wpdb->insert( 
        		$table_name, 
        		array(
        		    
        		    'id'     => '2',
        			'time'   => current_time( 'mysql' ), 
        			'name'   => $palette_name, 
        			'color1' => $color1,
        			'color2' => $color2,
        			'color3' => $color3,
        			'color4' => $color4,
        			'color4' => $color4,
        			'color5' => $color5,
        			'color6' => $color6,
        			'color7' => $color7,
        
                ) 
            );

    }
    
    gicpl_install();
    gicp_install_data();
}

add_action('after_switch_theme', 'setupdb_color_palette');