<?php get_header(); ?>

<div id="front-page" class="handwriting">
    
    <!--
    *
    *   Section: Welcome
    *
    -->
        
    <div id="top-section" class="row section top-section-wrap  zindex05 color1 ">
        <div id="top-content-wrap" class="content-area-wrap" >
                
            <div id="welcome-statement-wrap">
            
               <div id="welcome-name" class="handwriting opacity5 trans">
                    
                    <!-- Customizer data "Front Page Owner Name" -->
                    <h4><?php echo theme_mod_detail('fp_sec1_text_a', 'Personal or Company Name') ?>
                    </h4>
                    
                </div>
                
                <div id="statement1-wrap" class="trans">
                    
                    <div id="welcome-statement1-accent" class="color3">
                    </div>
                    
                    <div id="welcome-statement1" class="handwriting color2" >
    
                       <!-- Customizer data "Inspirational Call to Action" -->
                        <h2><?php echo theme_mod_detail('fp_sec1_text_b', 'Brief, inspirational call to action') ?>
                        </h2>
                        
                    </div>
                    
                </div>
                
                <div id="welcome-statement2" class="handwriting" >
                    
                    <!-- Customizer data "Direct Call to Action" -->          
                    <h1><?php echo theme_mod_detail('fp_sec1_text_c', 'Are you Ready?') ?>
                    
                    </h1>
                    
                </div>
                
                <div id="gi-navarrow-dwn" class="trans">M
                </div>
                
            </div> <!-- END #welcome-statement-wrap -->
    
            <div class="image-wrap">
                
                <div class="image-acent color4-grad-radial">
                </div>
                 
                <div id="welcome-image" <?php echo theme_mod_bkgrnd_image('fp_welcome_image')?>>
                    
                    <div id="grad-box-1" class="color2">
                    </div>
                    
                </div>
                
            </div>
            
            <!-- Gradient edge -->
            <div id="top-section-gradbottom" class="grad-bottom zindex05 color1 color1-grad zindex10">
            </div>
        
        </div>
        
    </div><!-- END #top-section -->
    

    <!--
    *
    *   Section: Main
    *
    -->
        
    <!-- Gradient edge -->
    <div id="main-section-gradtop" class="grad-top color2 color2-grad zindex10">
    </div>
    
    <div id="main-section" class="section section-content row color2 zindex10">

        <div id="main-section-content" class="content-area ">
	    
    	    <div class="section-title-wrap">
    	        
        	    <div class="section-title">
        	        
        	        <!-- Customizer data "Section Title" for "Section 2"--> 
        	        <h2><?php echo theme_mod_detail( 'fp_sec2_text_a', 'Featured Posts' ) ?>
        	        </h2>
        	        
        	    </div>
        	    
        	    <div class="section-subtitle">
        	    
            	    <!-- Customizer data "Direct Call to Action" for "Section 2"-->     
            	    <p><?php echo theme_mod_detail( 'fp_sec2_text_b', 'An optional subtitle to offer a brief expanlation' ) ?>
            	    </p>
        	    
        	    </div>
        	    
    	    </div>
    	    
    		<div id="main-content" class="site-content showcase-horz1" >
    		    
    		    <?php 
    		    $chosen_tag = '';
    		    $chosen_cat = '';
    		 
    		    // Customizer "Tag Filter" toggle in "Section 2"; On = grab tag
    		    if ( true ==  get_theme_mod( 'fp_sec2_tag_toggle' ) ) {
        		    $chosen_tag = get_theme_mod('fp_sec2_tag');
    		    };
    		    
    		    // Customizer "Category Filter" toggle in "Section 2"; On = grab cat
    		    if ( true ==  get_theme_mod( 'fp_sec2_cat_toggle' ) ) {
        		    $chosen_cat = get_theme_mod('fp_sec2_cat');
    		    };
    		    ?>
    		    
        	    <!-- The loop -->  
                <?php 
                $args= array(
                                'post_type'      => 'post',
                                'tag_id' => $chosen_tag,
                                'cat' => $chosen_cat,
                                'paged' => $paged,
                                'posts_per_page' =>  3,
                                'post__not_in' => get_option( 'sticky_posts' )
                            );
        
                $query = new WP_Query($args);
                    
                if ( $query->have_posts() ) {
                    
    			    // Start the Loop.
    			    while ( $query->have_posts() ) :
    			        
    				    $query->the_post();
    		    ?>
    		    
    				    <article id="post-
    				                    <?php the_ID(); ?>"
    				                    <?php post_class('clearfix'); ?>
    				    >
    				        
    				        <a href="<?php the_permalink(); ?>">
    				        
                            	<?php
                            	
                            	// Post thumb as a background image
                            	$thumb_url = wp_get_attachment_url( get_post_thumbnail_id($post->ID) );
                            	?>
                            	
                            	<div class='showcase-feat-img' style="background-image: url(<?php echo $thumb_url ?>)">
                            	</div>
                            	
                            </a>
                        	
                        
                        	<div class="entry-content clearfix">
                        	    
                        		    <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
                            		        <h3><?php the_title(); ?>
                            		        </h3>
                        		        </a>
                        		        
                            	<?php the_excerpt();
                        		?>
                                    
                            </div> <!-- END .entry-content -->
                            
                            <?php 
                        	edit_post_link( __( 'Edit', 'human-connection' ), '<span class="edit-link">', '</span>' );
                        	?>
     
                        </article> <!-- #post-## -->
                        
                        <?php
    
    				endwhile; // end the Loop.
    				
                } else {
                    
                    echo 'No Posts Found';
                }
    
                wp_reset_postdata();
    			?>
    		
    		</div> <!-- #main-content -->
    		
    		<?php 
            // If there is a category selected, use that for the link
            if($chosen_cat != '' ) {
            ?>
                    <div class="section-more-link">
                        
            	        <a href="<?php echo esc_url( get_category_link($chosen_cat) ) ?>"><?php echo theme_mod_detail( 'fp_sec2_text_c', 'This way for more' ) ?>
            	        </a>
            	        
        	        </div>
            <?php  
            }
            
            // If no category is selected, check for a tag
            elseif($chosen_tag !== '') {
                
                    $slug  = get_term( $chosen_tag, 'post_tag' );
                    $slug = $slug->slug;
            ?>
                    <div class="section-more-link">
            	        <a href="<?php echo esc_url( get_term_link( $slug, 'post_tag' )) ?>"><?php echo theme_mod_detail( 'fp_sec2_text_c', 'This way for more' ) ?>
            	        </a>
            	        
        	        </div>
            <?php
            } 
            
            // If no category nor tag has been
            // slected, use the posts page for the link
            else {
            ?>
                    <div class="section-more-link">
            	        <a href="<?php echo esc_url( get_permalink( get_option( 'page_for_posts' ) )) ?>"><?php echo theme_mod_detail( 'fp_sec2_text_c', 'This way for more' ) ?></a>
        	        </div>                    
             <?php
                
            }
            ?>
        
        </div> <!-- END #main-section-content -->
    
    </div> <!-- END #main-section -->
 
     <!-- Gradient edge -->   
    <div id="main-section-gradbottom" class="grad-bottom color2 color2-grad zindex10">
    </div>

    <!--
    *
    *   Section: Quote
    *
    -->
        
    <div id="quote-section1" class="section quote-area row handwriting color1 ">
        
        <div id="quote1a" class="page-quote-wrap" >
            
            <!-- Customizer data "Front Page Quote Text" for "Section 3"--> 
            <h2 class="page-quote trans-lin0"><?php echo get_theme_mod( 'home_quote_text_a', "This is where an inspiring quote can be used to keep the viewer's attention and deepen their engagement. The ideal size for this is between 100 to 200 characters long, but almost any length will work. ")?>
            </h2>
        
        </div>
        
        <!-- Customizer data "Front Page Quote Author" for "Section 3"--> 
        <div id="quote1b"  class="page-quote-wrap" >
            
            <h2 class="page-quote trans-lin0  delay">- <?php echo get_theme_mod( 'home_quote_text_b', "This is where the quote author can get some love. ")?>
            </h2>
        
        </div>
        
    </div>
    
    <!--
    *
    *   Section: Secondary
    *
    -->
        
    <!-- Gradient edge -->   
    <div id="secondary-section-gradtop" class="grad-top color3 color3-grad zindex10">
    </div>
    
    <div id="secondary-section" class="section row section-content color3 zindex10">
        
        <div id="secondary-section-content" class="content-area ">
            
    	            		    
    		<div class="section-title-wrap">
    		    
        	    <div class="section-title">
            	        
            	        <!-- Customizer data "Section Title" for "Section 3"--> 
            	        <h2><?php echo theme_mod_detail( 'fp_sec4_text_a', 'Services' ) ?>
            	        </h2>
            	</div>
            	
        	    <div class="section-subtitle">
        	        
        	        <p><?php echo theme_mod_detail( 'fp_sec4_text_b', 'An optional subtitle to offer a brief expanlation' ) ?>
        	        </p>
        	        
        	    </div>
        	    
            </div>
        		    
        		<div id="content" class="site-content showcase-horz1" role="main">
        		
        		    <?php 
        		    $chosen_tag = '';
        		    $chosen_cat = '';
        		    
        		    // If toggle from customizer is turned on, then grab the chosen tag ID
        		    if ( true ==  get_theme_mod( 'fp_sec4_tag_toggle' ) ) {
            		    $chosen_tag = get_theme_mod('fp_sec4_tag');
        		    };
        		    
        		    // If toggle from customizer is turned on, then grab the chosen category ID
        		    if ( true ==  get_theme_mod( 'fp_sec4_cat_toggle' ) ) {
            		    $chosen_cat = get_theme_mod('fp_sec4_cat');
        		    };
        		    ?>

            	    <!-- The loop  -->  
                    <?php 
                    $second_args= array(
                                            'post_type' => 'post',
                                            'tag_id' => $chosen_tag,    
                                            'cat' => $chosen_cat,
                                            'paged' => $paged,
                                            'posts_per_page' =>  3,
                                            'post__not_in' => get_option(           'sticky_posts' )
                                        );
            
                    $second_query = new WP_Query($second_args);
                    
                    if ( $second_query->have_posts() ) {
                        
        			    // Start the Loop.
        			    while ( $second_query->have_posts() ) :
        				    $second_query->the_post();
        		    ?>
        		            
        				    <article id="post-
        				                    <?php the_ID(); ?>"
        				                    <?php post_class('clearfix'); ?>>
    
        				        <a href="<?php the_permalink(); ?>">
        				        
                                	<?php
                                	// Post thumb as a background image
                                	$thumb_url = wp_get_attachment_url( get_post_thumbnail_id($post->ID) );
                                	?>
                                	
                                	<div class='showcase-feat-img' style="background-image: url(<?php echo $thumb_url ?>)">
                                	    
                                	</div>
                                	
                                </a>
                            	
                            	<div class="entry-content clearfix">
                            	
                    		    <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
                    		        
                        		        <h3><?php the_title(); ?>
                        		        </h3>
                        		        
                    		        </a>
                    		        
                                <?php the_excerpt(); ?>
                                                
                                </div><!-- /.entry-content -->
                                <?php 
                            			edit_post_link( __( 'Edit', 'human-connection' ), '<span class="edit-link">', '</span>' );
                            	?>
    
                            </article><!-- #post-## -->
                            <?php
                				
        				endwhile; // end the Loop.
        				
                    } else {
                        
                        echo 'No Posts Found';
                    }

                wp_reset_postdata();
                 ?>
        		
        		</div><!-- #content -->
        		
        		<?php
                // If there is a category selected, use that for the link
                if($chosen_cat != '' ) {
                ?>
                        <div class="section-more-link">
                	        <a href="<?php echo esc_url( get_category_link($chosen_cat) ) ?>"><?php echo theme_mod_detail( 'fp_sec4_text_c', 'This way for more' ) ?></a>
            	        </div>
                <?php 
                }
                
                // If there is not a category selected, check for a tag
                elseif($chosen_tag !== '') {
                    
                        $slug  = get_term( $chosen_tag, 'post_tag' );
                        $slug = $slug->slug;
                ?>
                        <div class="section-more-link">
                	        <a href="<?php echo esc_url( get_term_link( $slug, 'post_tag' )) ?>"><?php echo theme_mod_detail( 'fp_sec4_text_c', 'This way for more' ) ?></a>
            	        </div>
                <?php
                }
                
                // If niether a category or atg has been slected, us teh posts page for the link
                else {
                    
                ?>
                        <div class="section-more-link">
                	        <a href="<?php echo esc_url( get_permalink( get_option( 'page_for_posts' ) )) ?>"><?php echo theme_mod_detail( 'fp_sec4_text_c', 'This way for more' ) ?></a>
            	        </div>
            	        
                <?php
                }
    	        ?>

        </div> <!-- END #secondary-section-content -->
    
    </div> <!-- END #secondary-section-content -->
    
    
    <div id="secondary-section-gradbottom" class="grad-bottom color3 color3-grad zindex10"></div>
    
    <!--
    *
    *   Section: Pre-Footer
    *
    -->
        
    <!-- Gradient edge --> 
    <div id="pre-footer-gradtop" class="grad-top color4 color4-grad zindex10">
    </div>
    
    <div id="pre-footer-section" class="section row color4 zindex10">
        
            <div id="footer-center-wrap" class="center-wrap">
                
                <div id="footer-form" class="contact-form handwriting">
                    
                    <?php include('contact_form.php'); ?>
                    
                </div><!-- END #footer-form -->
                
            </div><!-- END #footer-center-wrap -->
            
    </div><!-- END #pre-footer-section -->
    
    <!-- Gradient edge -->    
    <div id="pre-footer-gradbottom" class="grad-bottom color4 color4-grad zindex10">
    </div>

</div><!-- END #standard-page -->
   
<?php get_footer(); ?>