<?php
/**
 * The template for displaying archive pages
 *
 * @package WordPress
 * @subpackage Human_Connection
 * @since 1.0
 * @version 1.0
 */
?>
             
<?php get_header(); ?>

<div id="archive-page" class="handwriting">

    <!--
    *
    *   Section: Welcome
    *
    -->
         
    <div id="top-section" class="row section top-section-wrap  color1">
        <div id="page-title-wrap" class="title-wrap">

            <div id="page-title">
                
                <?php
				    single_term_title( '<h1 class="page-title">', '</h1>' );
			    ?>
			    
                </a>
                
            </div>
            
            <div id="page-desc" class="page-desc">
                
                <h3>
                    
                    <?php
        			the_archive_description( '<div class="taxonomy-description">', '</div>' );
			        ?>
			        
                </h3>
            </div>

        </div><!-- END #page-title-wrap -->
 
        <div class="image-wrap">
            <div class="image-acent color4-grad-radial"></div>
            <div id="welcome-image">
                <div id="grad-box-1" class="color2"></div>
            </div>
        </div>
        
    </div><!-- END #top-section -->
    
    
    <!-- Gradient edge -->     
    <div id="top-section-gradbottom" class="grad-bottom color1 color1-grad zindex10">
    </div>
    
    <!--
    *
    *   Section: Main
    *
    -->
    
    <!-- Gradient edge -->       
    <div id="main-section-gradtop" class="grad-top color2 color2-grad zindex10">
    </div>
   
    <div id="main-section" class="section section-content row color2 zindex10">
                
        <div id="primary" class="content-area">
            
            <div id="content" class="site-content" role="main">
    		    
                <?php if(have_posts()) : ?>
                
    		    <div id="ms-container">
    		        
    		        <div id="masonry-loop">
    		             
                        <?php 
                        $query = new WP_Query(); 
    
            			    // Start the Loop.
            			    while ( have_posts() ) :
            				    the_post();
            		    ?>
            		    
            		            <!-- Set the unique post ID and class -->
            				    <article id="post-<?php the_ID(); ?>"
            				                    <?php post_class('ms-item'); ?>
            				    >
            				        
                                	<?php
                                	// Page thumbnail and title
                                	the_post_thumbnail();
                                	
                                	?>
                                	
                                	<header class="entry-header">
                                	    
                                	    <h2 class="entry-title">
                                	        
                                            <a href= "<?php the_permalink(); ?>" title= "<?php the_title_attribute(); ?>" 
                                            >
                                            <?php
                                        	the_title();
                                        	?>
                                            </a>
                                            
                                        </h2>
                                        
                                    </header><!-- .entry-header -->
                                    
                                	<div class="entry-content">
                                	    
                                		<?php
                                		// Post body content
                            			the_excerpt();
                            			?>
                                			
                            			By <?php the_author_posts_link(); ?>     on <?php the_time('F jS, Y'); ?>  in     <div class="cat-tag-wrap">
                            			     <?php the_category(', '); ?>.      </div>
                                		
                                		<!-- Add the link to the post editor     -->	
                            			<?php edit_post_link( __( 
                            			    'Edit', 
                            			    'human-connection' ), 
                            			    '<span class="edit-link">', 
                            			    '</span>' );
                                		?>
                                		
                                		
                                    </div><!-- .entry-content -->
    
                                </article><!-- #post-## -->
                                
                                <?php
                    				// If comments are open or we have at least one comment, load up the comment template.
                    				if ( comments_open() || get_comments_number() ) {
                    					comments_template();
                    				}
	    
        				    endwhile; // End the loop
        			        ?>

            		        </div><!--/END #masonry-loop-->
    
            		    </div><!-- /END #ms-container -->
            		    
            		    <!-- Post navigation -->
                       <?php postnav_numberbar(); ?> 
                       
             		<?php else : ?>
             		
                            <div class="error-no-posts"><h3>Oh no! There is nothing to show.</h3><p>Please try a search for another term or use the menu to find great content on another page
                            </p>
                            </div>
                            
                    <?php endif; ?>  

            </div><!-- #content -->

            <!-- Page navigation -->
            <?php pagenav_standard() ?>

        </div> <!-- END #primary -->

        <div id="secondary" class="sidebar" >
            
            <?php get_template_part( 'template_parts/sidebar_template'); ?>
            
        </div><!-- #secondary -->
            
    </div> <!-- END #main-section -->
    
    <!-- Gradient edge -->             
    <div id="main-section-gradbottom" class="grad-bottom color2 color2-grad zindex10"></div>

    <!--
    *
    *   Section: Pre-Footer
    *
    -->

    <!-- Gradient edge --> 
    <div id="pre-footer-gradtop" class="grad-top color3 color3-grad zindex10"></div>
    
    <div id="pre-footer-section" class="section row color3 zindex10">
        
            <div id="footer-center-wrap" class="center-wrap">
                
                <div id="footer-form" class="contact-form handwriting"> 
                    
                    <!-- Grab the contact form -->
                    <?php include('contact_form.php'); ?>
                    
                </div><!-- END #footer-form -->
                
            </div><!-- END #footer-center-wrap -->
            
    </div><!-- END #pre-footer-section -->
    
    
    <!-- Gradient edge --> 
    <div id="pre-footer-gradbottom" class="grad-bottom color3 color3-grad zindex10">
    </div>

    <script type="text/javascript">
    
        // This adds support for the masonary post layout
        jQuery(window).load(function() {
          var container = document.querySelector('#ms-container');
          var msnry = new Masonry( container, {
            itemSelector: '.ms-item',
            columnWidth: '.ms-item',                
          });  
          
        });
        
    </script>
    
</div><!-- END #archive-page -->

<?php get_footer(); ?>