<?php
/**
 * Human Connection 404 Page
 *
 * @package WordPress
 * @subpackage human_connection
 * @since 1.0
 * @version 1.0
 */
?>

<?php get_header(); ?>

<div id="four-o-four-page" class="handwriting">
    
    <!--
    *
    *   Section: Welcome
    *
    -->
         
    <div id="top-section" class="row section top-section-wrap  color1">
    
        <div id="page-title-wrap" class="title-wrap">
            
            <div id="page-title">
                
                <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
                   Oh no!
                </a>
                
            </div>
            
            <div id="page-desc" class="page-desc">
                
                <h3>We can't seem to find that page here.
                </h3>
                
            </div>
            
        </div><!-- END #page-title-wrap -->
             
        <div class="image-wrap">
            
            <div class="image-acent color4-grad-radial">
            </div>
            
            <div id="welcome-image">
                
                <div id="grad-box-1" class="color2">
                </div>
                
            </div>
            
        </div> <!-- END #image-wrap -->
        
    </div><!-- END #top-section -->
    
    <div id="top-section-gradbottom" class="grad-bottom color1 color1-grad zindex10"></div>
    
    <!--
    *
    *   Section: Main
    *
    -->
         
    <!-- Gradient edge -->
    <div id="main-section-gradtop" class="grad-top color2 color2-grad zindex10"></div>
   
    <div id="main-section" class="section section-content row color2 zindex10">
    
        <div id="primary" class="content-area">    

            <div id="content" class="site-content" role="main">
        		    
                <p>
                    You
                    <?php
                    
                    // The Wordpress admin email address
                    $adminemail = get_option('admin_email');    
                    
                    // The blog url from wordpress
                    $website = get_bloginfo('url');     
                    
                    // sets the blog's name from Wordpress
                    $websitename = get_bloginfo('name');
                    
                    // Below will alert of a user-caused problem   
                    if (!isset($_SERVER['HTTP_REFERER'])) { 
                            
                        // Begins assembling an output paragraph
                        echo "tried going to <strong><br>"; 
                            
                    	$casemessage = "<br><br><strong>All is not lost!</strong>";
                    	
                    } elseif (isset($_SERVER['HTTP_REFERER'])) {
                        
                        // Below will help the user find what they want while sending the admin an email about the problem
                    	echo "clicked a link to"; 
                        
                        // the following sets up the email to be sent  
                    	$failuremess = "A user tried to go to $website" 
                            .$_SERVER['REQUEST_URI']." and received a 404 (page not found) error. ";
                            
                    	$failuremess .= "It wasn't their fault, so try fixing it.  
                            They came from ".$_SERVER['HTTP_REFERER'];
                        
                        // Email admin about the problem    
                    	mail($adminemail, "Bad Link To ".$_SERVER['REQUEST_URI'],
                            $failuremess, "From: $websitename <noreply@$website>");
                        
                        // A friendly closing to the message   
                    	$casemessage = "An administrator has been emailed 
                            about this problem, as well.";
                    }
                      
                    echo " ".$website.$_SERVER['REQUEST_URI']; ?> 
                    
                    </strong><br>This does not appear to exist. <?php echo $casemessage; ?>
                    
                </p>
                
				<p>
				    <?php _e( 'Perhaps, searching our site will help you find what you are looking for?', 'human-connection' ); ?>
				</p>                    

                <!-- Add the search form -->
				<?php get_search_form(); ?>
				
            </div><!-- /END #content -->

 			<p>
			    <?php _e( 'If you prefer, you can jump to another page right here:', 'human-connection' ); ?>
			</p> 
			
            <!-- Page Navigation --> 				
            <?php pagenav_special_post() ?>
    
	    </div><!-- #primary -->
	
        <div id="secondary" class="sidebar-area" >
        
            <?php get_template_part( 'template_parts/sidebar_template'); ?>
            
        </div><!-- #secondary -->

    </div><!-- /END #main-section -->
    
    <!-- Gradient edge -->   
    <div id="main-section-gradbottom" class="grad-bottom color2 color2-grad zindex10"></div>
   
    <!--
    *
    *   Section: Pre-Footer
    *
    -->
         
    <div id="pre-footer-gradtop" class="grad-top color3 color3-grad zindex10"></div>

    <div id="pre-footer-section" class="section row color3 zindex10">
        
            <div id="footer-center-wrap" class="center-wrap">
                
                <div id="footer-form" class="contact-form handwriting"> 
                    
                    <!-- Grab the contact form -->
                    <?php include('contact_form.php'); ?>
                    
                </div><!-- END #footer-form -->
                
            </div><!-- END #footer-center-wrap -->
            
    </div><!-- END #pre-footer-section -->

    <!-- Gradient edge --> 
    <div id="pre-footer-gradbottom" class="grad-bottom color3 color3-grad zindex10"></div>

</div><!-- END #four-o-four-page -->
   
<?php get_footer(); ?>
